<div>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('message')): ?>
                    <div class="alert alert-success alert-dismissible fade show text-white" role="alert">
                        <?php echo e(session('message')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show text-white" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Job Applications</h5>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-applications">
                            <thead class="thead-light">
                                <tr>
                                    <th>s/n</th>
                                    <th>Job Title</th>
                                    <th>Applicant</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Resume</th>
                                    <th>Cover Letter</th>
                                    <th>Applied At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($application->job->title); ?></td>
                                        <td><?php echo e($application->first_name); ?> <?php echo e($application->last_name); ?></td>
                                        <td><?php echo e($application->email); ?></td>
                                        <td><?php echo e($application->phone); ?></td>
                                        <td>
                                            <button type="button" class="btn btn-sm btn-primary text-white" data-bs-toggle="modal" data-bs-target="#pdfModal<?php echo e($application->id); ?>">
                                                View Resume
                                            </button>
                                            <!-- PDF Preview Modal -->
                                            <div class="modal fade" id="pdfModal<?php echo e($application->id); ?>" tabindex="-1" aria-labelledby="pdfModalLabel<?php echo e($application->id); ?>" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="pdfModalLabel<?php echo e($application->id); ?>">Resume - <?php echo e($application->first_name); ?> <?php echo e($application->last_name); ?></h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div id="pdfViewer<?php echo e($application->id); ?>" class="pdf-viewer" style="height: 600px;">
                                                                <iframe src="https://docs.google.com/viewer?url=<?php echo e(urlencode($application->resume_url)); ?>&embedded=true" width="100%" height="100%" style="border: none;"></iframe>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-sm bg-secondary px-4 text-white" data-bs-toggle="modal" data-bs-target="#coverLetterModal<?php echo e($application->id); ?>">
                                                View
                                            </button>
                                            <div class="modal fade" id="coverLetterModal<?php echo e($application->id); ?>" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Cover Letter</h5>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <?php echo nl2br(e($application->cover_letter)); ?>

                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($application->created_at->format('M d, Y')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($applications->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
        <script>
            document.addEventListener('livewire:initialized', function () {
                const dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                    searchable: true,
                    fixedHeight: true,
                    perPage: <?php echo e($perPage); ?>,
                    perPageSelect: [5, 10, 25, 50],
                    labels: {
                        placeholder: "Search...",
                        perPage: "{select} entries per page",
                        noRows: "No entries found",
                        info: "Showing {start} to {end} of {rows} entries"
                    }
                });

                Livewire.on('tableUpdated', () => {
                    dataTableSearch.destroy();
                    dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                        searchable: true,
                        fixedHeight: true,
                        perPage: <?php echo e($perPage); ?>,
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/Dumes/resources/views/livewire/admin/admin-job-application-component.blade.php ENDPATH**/ ?>