<div>
<div class="pbmit-slider-area pbmit-slider-one">
    <div class="swiper-slider" data-autoplay="true" data-loop="true" data-dots="false" data-arrows="true" data-columns="1" data-margin="0" data-effect="fade">
        <div class="swiper-wrapper">

            <!-- Slide1 -->
            <div class="swiper-slide">
                <div class="pbmit-slider-item">
                    <div class="pbmit-slider-bg" style="background-image: url(/assets/images/banner-slider-img/slider1.jpg);"></div>
                    <div class="container">
                        <div class="pbmit-slider-content">
                            <h5 class="pbmit-slider-subtitle transform-right transform-delay-1">
                                Powering Your Projects
                            </h5>
                            <h5 class="pbmit-slider-title transform-right transform-delay-2">
                                Heavy-Duty Equipment <br>Your Project Needs
                            </h5>
                            <div class="d-lg-flex align-items-center justify-content-end">
                                <div class="pbmit-slider-desc transform-center transform-delay-3">
                                    Reliable machines and expert support for construction, civil works, and industrial operations.  
                                </div>
                                <div class="pbmit-button ms-xl-5 ms-lg-3">
                                    <div class="transform-bottom transform-delay-4">
                                        <a href="<?php echo e(route('services')); ?>" class="pbmit-btn white">
                                            <span class="pbmit-button-content-wrapper">
                                                <span class="pbmit-button-icon">
                                                    <i class="fas fa-arrow-right"></i>

                                                </span>
                                                <span class="pbmit-button-text">Learn More</span>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Slide2 -->
            <div class="swiper-slide">
                <div class="pbmit-slider-item">
                    <div class="pbmit-slider-bg" style="background-image: url(/assets/images/banner-slider-img/slider2.jpg);"></div>
                    <div class="container">
                        <div class="pbmit-slider-content">
                            <h5 class="pbmit-slider-subtitle transform-right transform-delay-1">
                                Reliable Machinery
                            </h5>
                            <h2 class="pbmit-slider-title transform-right transform-delay-2">
                                Equipment Leasing <br>For Every Construction Need
                            </h2>
                            <div class="d-lg-flex align-items-center justify-content-end">
                                <div class="pbmit-slider-desc transform-center transform-delay-3">
                                    From excavators to cranes, we deliver equipment built for performance and durability.
                                </div>
                                <div class="pbmit-button ms-xl-5 ms-lg-3">
                                    <div class="transform-bottom transform-delay-4">
                                        <a href="<?php echo e(route('services')); ?>" class="pbmit-btn white">
                                            <span class="pbmit-button-content-wrapper">
                                                <span class="pbmit-button-icon">
                                                    <i class="pbmit-induyst-icon pbmit-induyst-icon-next"></i>
                                                </span>
                                                <span class="pbmit-button-text">Learn More</span>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Slide3 -->
            <div class="swiper-slide">
                <div class="pbmit-slider-item">
                    <div class="pbmit-slider-bg" style="background-image: url(/assets/images/banner-slider-img/slider3.jpg);"></div>
                    <div class="container">
                        <div class="pbmit-slider-content">
                            <h5 class="pbmit-slider-subtitle transform-right transform-delay-1">
                                Engineering You Can Trust
                            </h5>
                            <h2 class="pbmit-slider-title transform-right transform-delay-2">
                                Civil Works & <br>Logistics Solutions
                            </h2>
                            <div class="d-lg-flex align-items-center justify-content-end">
                                <div class="pbmit-slider-desc transform-center transform-delay-3">
                                    Road construction, drainage systems, and logistics support executed with precision.
                                </div>
                                <div class="pbmit-button ms-xl-5 ms-lg-3">
                                    <div class="transform-bottom transform-delay-4">
                                        <a href="<?php echo e(route('services')); ?>" class="pbmit-btn white">
                                            <span class="pbmit-button-content-wrapper">
                                                <span class="pbmit-button-icon">
                                                    <i class="pbmit-induyst-icon pbmit-induyst-icon-next"></i>
                                                </span>
                                                <span class="pbmit-button-text">Learn More</span>
                                            </span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- page content -->
<div class="page-content">

<!-- Service Start --> 
<section class="section-xxl fade-section">
    <div class="container">
        <div class="d-md-flex justify-content-between">
            <div class="pbmit-heading-subheading">
                <h4 class="pbmit-subtitle">Our Services</h4>
                <h2 class="pbmit-title">Reliable solutions for <br class="d-inline"> construction and engineering</h2>
            </div>
            <div class="service-arrow d-inline-flex"></div>
        </div>

        <div class="swiper-slider" data-autoplay="true" data-loop="true" data-dots="false" data-arrows="true" data-arrows-class="service-arrow" data-columns="3" data-margin="30" data-effect="slide">
            <div class="swiper-wrapper">

                <!-- Service 1 -->
                <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/heavy.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon">
                                        <i class="fas fa-tractor"></i>

                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'heavy-duty-equipment-leasing'])); ?>"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="<?php echo e(route('service.detail', ['slug' => 'heavy-duty-equipment-leasing'])); ?>">Heavy-Duty Equipment Leasing</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>We supply excavators, payloaders, graders, rollers, cranes, and lowbeds for construction and industrial use.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="<?php echo e(route('service.detail', ['slug' => 'heavy-duty-equipment-leasing'])); ?>">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'heavy-duty-equipment-leasing'])); ?>"></a>
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Service 2 -->
                <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/civil-works.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon">
                                        <i class="fas fa-road"></i>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'civil-works-infrastructure'])); ?>"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="<?php echo e(route('service.detail', ['slug' => 'civil-works-infrastructure'])); ?>">Civil Works & Infrastructure</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>We handle road construction, drainage systems, erosion control, and solar street light installations.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="<?php echo e(route('service.detail', ['slug' => 'civil-works-infrastructure'])); ?>">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'civil-works-infrastructure'])); ?>"></a>
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Service 3 -->
                <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/logistics_procurement.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon">
                                        <i class="fas fa-truck-fast"></i>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'logistics-procurement'])); ?>"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="<?php echo e(route('service.detail', ['slug' => 'logistics-procurement'])); ?>">Logistics & Procurement</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>We deliver reliable logistics support, equipment haulage, and procurement services for seamless operations.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="<?php echo e(route('service.detail', ['slug' => 'logistics-procurement'])); ?>">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'logistics-procurement'])); ?>"></a>
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Service 4 -->
                <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/site_preparation.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>

                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon">
                                        <i class="fas fa-trowel-bricks"></i>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'site-preparation-earthworks'])); ?>"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="<?php echo e(route('service.detail', ['slug' => 'site-preparation-earthworks'])); ?>">Site Preparation & Earthworks</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>Professional excavation, grading, land clearing, and foundation preparation for construction projects.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="<?php echo e(route('service.detail', ['slug' => 'site-preparation-earthworks'])); ?>">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'site-preparation-earthworks'])); ?>"></a>
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Service 5 -->
                <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/construction_drainage.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>

                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon">
                                        <i class="fas fa-hard-hat"></i>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'road-construction-drains'])); ?>"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="<?php echo e(route('service.detail', ['slug' => 'road-construction-drains'])); ?>">Road Construction and Drains</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>Expert road construction and drainage system installation to ensure durable infrastructure and water management.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="<?php echo e(route('service.detail', ['slug' => 'road-construction-drains'])); ?>">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'road-construction-drains'])); ?>"></a>
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Service 6 -->
                <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/solar-street-lights.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>

                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon">
                                        <i class="fas fa-lightbulb"></i>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'solar-street-light-installations'])); ?>"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="<?php echo e(route('service.detail', ['slug' => 'solar-street-light-installations'])); ?>">Solar Street Light Installations</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>Sustainable solar street lighting solutions for communities, ensuring safety and efficiency with renewable power.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="<?php echo e(route('service.detail', ['slug' => 'solar-street-light-installations'])); ?>">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="<?php echo e(route('service.detail', ['slug' => 'solar-street-light-installations'])); ?>"></a>
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Service 5 -->
                <!-- <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/service-img-05.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>

                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon"></div>
                                </div>
                                <a class="pbmit-link" href="service-details.html"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="service-details.html">Engineering Support Services</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>Technical consultation, structural assessments, and engineering supervision for project excellence.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="service-details.html">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="service-details.html"></a>
                            </div>
                        </div>
                    </div>
                </article> -->

                <!-- Service 6 -->
                <!-- <article class="pbmit-service-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-box-content-wrap">
                            <div class="pbmit-image-wrap">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/service/service-img-06.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>

                                <div class="pbmit-service-icon-wrapper">
                                    <div class="pbmit-service-icon">
                                        <i class="fas fa-gem"></i>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="service-details.html"></a>
                            </div>

                            <div class="pbmit-service-content-wrap">
                                <h3 class="pbmit-service-title">
                                    <a href="service-details.html">Mining & Material Extraction</a>
                                </h3>
                                <div class="pbmit-service-description">
                                    <p>Support for mining operations including excavation, haulage, and extraction of solid raw materials.</p>
                                </div>
                                <div class="pbmit-service-btn-wrapper">
                                    <div class="pbmit-service-btn">
                                        <a class="pbmit-button-inner" href="service-details.html">
                                            <span class="pbmit-button-text">Read More</span>
                                            <i class="pbmit-base-icon-right-arrow"></i>
                                        </a>
                                    </div>
                                </div>
                                <a class="pbmit-link" href="service-details.html"></a>
                            </div>
                        </div>
                    </div>
                </article> -->

            </div>
        </div>

        <div class="pbmit-bottom-text text-center mt-5 pt-md-2">
            Delivering trusted equipment and engineering support for successful projects. <a href="<?php echo e(route('services')); ?>"><u>Explore All Services</u></a>
        </div>
    </div>
</section>
<!-- Service End --> 

<!-- About Start --> 
<section class="about-section-one pbmit-bg-color-blackish" data-aos="fade-up" data-aos-duration="800">
    <div class="container-fluid p-0">
        <div class="row g-0">
            <div class="col-md-4">
                <div class="about-one-left-bg"></div>
            </div>

            <div class="col-md-8">
                <div class="about-one-right-box">
                    <div class="row align-items-center">
                        <div class="col-md-6 left-col">
                            <div class="pe-3">
                                <div class="pbmit-heading-subheading">
                                    <h4 class="pbmit-subtitle">Why Choose Us</h4>
                                    <h2 class="pbmit-title">Your trusted partner in construction equipment & engineering</h2>
                                    <div class="pbmit-heading-desc">
                                        We provide dependable machinery, experienced professionals, and quality-driven engineering services for all project sizes.
                                    </div>
                                </div>

                                <div class="d-flex align-items-center pbmit-buttons">
                                    <a href="<?php echo e(route('about')); ?>" class="pbmit-btn">
                                        <span class="pbmit-button-content-wrapper">
                                            <span class="pbmit-button-icon">
                                                <i class="pbmit-induyst-icon pbmit-induyst-icon-next"></i>
                                            </span>
                                            <span class="pbmit-button-text">Learn More</span>
                                        </span>
                                    </a>

                                    <!-- <div class="ms-4">
                                        <a class="pbmit-btn-style-text" href="our-team.html">
                                            <span class="pbmit-button-text">Work With Us</span>
                                        </a>
                                    </div> -->
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 right-col">
                            <div class="ihbox-style-area">
                                <div class="row pbminfotech-gap-40px g-0">

                                    <article class="pbmit-miconheading-style-1 col-md-12">
                                        <div class="pbmit-ihbox-style-1">
                                            <div class="pbmit-ihbox-box">
                                                <div class="pbmit-ihbox-icon">
                                                    <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                                        <i class="fas fa-user-shield"></i>
                                                    </div>
                                                </div>
                                                <div class="pbmit-ihbox-contents">
                                                    <h2 class="pbmit-element-title">
                                                        Certified & Experienced Team
                                                    </h2>
                                                </div>
                                            </div>
                                        </div>
                                    </article>

                                    <article class="pbmit-miconheading-style-1 col-md-12">
                                        <div class="pbmit-ihbox-style-1">
                                            <div class="pbmit-ihbox-box">
                                                <div class="pbmit-ihbox-icon">
                                                    <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                                        <i class="fas fa-star"></i>
                                                    </div>
                                                </div>
                                                <div class="pbmit-ihbox-contents">
                                                    <h2 class="pbmit-element-title">
                                                        Quality Service Delivery
                                                    </h2>
                                                </div>
                                            </div>
                                        </div>
                                    </article>

                                    <article class="pbmit-miconheading-style-1 col-md-12">
                                        <div class="pbmit-ihbox-style-1">
                                            <div class="pbmit-ihbox-box">
                                                <div class="pbmit-ihbox-icon">
                                                    <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                                        <i class="fas fa-hard-hat"></i>
                                                    </div>
                                                </div>
                                                <div class="pbmit-ihbox-contents">
                                                    <h2 class="pbmit-element-title">
                                                        Engineering Project Solutions
                                                    </h2>
                                                </div>
                                            </div>
                                        </div>
                                    </article>

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="list-group-wrap">
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="pbmit-icon-list-icon">
                                    <i class="fas fa-check"></i>						
                                </span>
                                <span class="pbmit-icon-list-text">24/7 Operational Support</span>
                            </li>

                            <li class="list-group-item">
                                <span class="pbmit-icon-list-icon">
                                    <i class="fas fa-check"></i>					
                                </span>
                                <span class="pbmit-icon-list-text">Cost-Effective Leasing Options</span>
                            </li>

                            <li class="list-group-item">
                                <span class="pbmit-icon-list-icon">
                                    <i class="fas fa-check"></i>					
                                </span>
                                <span class="pbmit-icon-list-text">Reliable & Trusted Service</span>
                            </li>

                            <li class="list-group-item">
                                <span class="pbmit-icon-list-icon">
                                    <i class="fas fa-check"></i>					
                                </span>
                                <span class="pbmit-icon-list-text">Environmentally Safe Operations</span>
                            </li>
                        </ul>
                    </div>

                </div>
            </div>

        </div>
    </div>
</section>
<!-- About End -->

<!-- Fid Start --> 
<section class="section-lgt fade-section">
    <div class="container">
        <div class="row">

            <!-- Stat 1 -->
            <div class="col-md-6 col-xl-4">
                <div class="pbminfotech-ele-fid pbminfotech-ele-fid-style-2">
                    <div class="pbmit-fld-contents">
                        <div class="pbmit-fld-wrap">
                            <div class="pbmit-fid-inner">
                                <span class="pbmit-fid-before"></span>
                                <span class="pbmit-number-rotate numinate" data-appear-animation="animateDigits" data-from="0" data-to="92" data-interval="5">92</span>
                                <span class="pbmit-fid"><span>%</span></span>
                            </div>
                            <h2 class="pbmit-fid-title"></h2>
                            <div class="pbmit-heading-desc">
                                Projects completed efficiently using our heavy-duty equipment.
                            </div>
                        </div>
                    </div>

                    <div class="pbmit-progressbar">
                        <div class="pbmit-progress-wrapper">
                            <div class="pbmit-progress-bar" data-max="92">1</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stat 2 -->
            <div class="col-md-6 col-xl-4 mt-md-0 mt-4">
                <div class="pbminfotech-ele-fid pbminfotech-ele-fid-style-2">
                    <div class="pbmit-fld-contents">
                        <div class="pbmit-fld-wrap">
                            <div class="pbmit-fid-inner">
                                <span class="pbmit-fid-before"></span>
                                <span class="pbmit-number-rotate numinate" data-appear-animation="animateDigits" data-from="0" data-to="85" data-interval="5">85</span>
                                <span class="pbmit-fid"><span>%</span></span>
                            </div>
                            <h2 class="pbmit-fid-title"></h2>
                            <div class="pbmit-heading-desc">
                                Clients experienced improved outcomes through our civil works services.
                            </div>
                        </div>
                    </div>

                    <div class="pbmit-progressbar">
                        <div class="pbmit-progress-wrapper">
                            <div class="pbmit-progress-bar" data-max="85">1</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Stat 3 -->
            <div class="col-md-6 col-xl-4 mt-xl-0 mt-md-5 mt-4">
                <div class="pbminfotech-ele-fid pbminfotech-ele-fid-style-2">
                    <div class="pbmit-fld-contents">
                        <div class="pbmit-fld-wrap">
                            <div class="pbmit-fid-inner">
                                <span class="pbmit-fid-before"></span>
                                <span class="pbmit-number-rotate numinate" data-appear-animation="animateDigits" data-from="0" data-to="90" data-interval="5">90</span>
                                <span class="pbmit-fid"><span>%</span></span>
                            </div>
                            <h2 class="pbmit-fid-title"></h2>
                            <div class="pbmit-heading-desc">
                                Operations enhanced through our logistics and equipment support.
                            </div>
                        </div>
                    </div>

                    <div class="pbmit-progressbar">
                        <div class="pbmit-progress-wrapper">
                            <div class="pbmit-progress-bar" data-max="90">1</div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>
<!-- Fid End -->


<!-- Ihbox Start --> 
<section class="section-md fade-section">
    <div class="container">

        <div class="pbmit-heading-subheading text-center">
            <h4 class="pbmit-subtitle">Working Process</h4>
            <h2 class="pbmit-title">How we deliver efficient <br> equipment & engineering solutions</h2>
        </div>

        <div class="swiper-slider ihbox-style-10-slider" data-autoplay="false" data-loop="true" data-dots="false" data-arrows="false" data-columns="4" data-margin="0" data-effect="slide">
            <div class="swiper-wrapper">

                <!-- Step 1 -->
                <article class="pbmit-miconheading-style-10 swiper-slide">
                    <div class="pbmit-ihbox-style-10">
                        <div class="pbmit-ihbox-box">
                            <span class="pbmit-box-number">01</span>
                            <div class="pbmit-ihbox-icon">
                                <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                    <i class="fas fa-clipboard-check"></i>
                                </div>
                            </div>
                            <h2 class="pbmit-element-title">
                                Equipment Assessment & Planning
                            </h2>
                            <div class="pbmit-heading-desc">
                                We evaluate your project needs and recommend the right heavy-duty machines.
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Step 2 -->
                <article class="pbmit-miconheading-style-10 swiper-slide">
                    <div class="pbmit-ihbox-style-10">
                        <div class="pbmit-ihbox-box">
                            <span class="pbmit-box-number">02</span>
                            <div class="pbmit-ihbox-icon">
                                <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                    <i class="fas fa-truck-moving"></i>
                                </div>
                            </div>
                            <h2 class="pbmit-element-title">
                                Logistics & Equipment Deployment
                            </h2>
                            <div class="pbmit-heading-desc">
                                Machines are transported safely and delivered efficiently to your project site.
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Step 3 -->
                <article class="pbmit-miconheading-style-10 swiper-slide">
                    <div class="pbmit-ihbox-style-10">
                        <div class="pbmit-ihbox-box">
                            <span class="pbmit-box-number">03</span>
                            <div class="pbmit-ihbox-icon">
                                <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                    <i class="fas fa-user-gear"></i>
                                </div>
                            </div>
                            <h2 class="pbmit-element-title">
                                Operations, Support & Supervision
                            </h2>
                            <div class="pbmit-heading-desc">
                                We provide trained operators, onsite supervision, and mechanical support.
                            </div>
                        </div>
                    </div>
                </article>

                <!-- Step 4 -->
                <article class="pbmit-miconheading-style-10 swiper-slide">
                    <div class="pbmit-ihbox-style-10">
                        <div class="pbmit-ihbox-box">
                            <span class="pbmit-box-number">04</span>
                            <div class="pbmit-ihbox-icon">
                                <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                    <i class="fas fa-building-circle-check"></i>
                                </div>
                            </div>
                            <h2 class="pbmit-element-title">
                                Project Execution & Completion
                            </h2>
                            <div class="pbmit-heading-desc">
                                Civil works, site operations, and logistics tasks are executed with precision.
                            </div>
                        </div>
                    </div>
                </article>

            </div>
        </div>

    </div>
</section>
<!-- Ihbox End -->
 



<!-- Team Start (Replaced with Heavy Equipment Showcase) --> 
<section class="section-xl team-section-one fade-section pbmit-column-four">
    <div class="container">
        <div class="pbmit-heading-subheading text-center">
            <h4 class="pbmit-subtitle">Equipment Showcase</h4>
            <h2 class="pbmit-title">Our Fleet of Reliable Heavy-Duty Machines</h2>
        </div>

        <div class="swiper-slider" data-autoplay="true" data-loop="false" data-dots="true" data-arrows="false" data-columns="4" data-margin="30" data-effect="slide">
            <div class="swiper-wrapper">

                <!-- Slide 1 – Excavator -->
                <article class="pbmit-team-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-featured-wrap">
                            <!-- <div class="pbmit-team-btn">
                                <a class="pbmit-team-text" href="#">
                                    <i class="pbmit-base-icon-share"></i>
                                </a>
                            </div> -->
                            <div class="pbmit-featured-inner">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/Excavators.jpg" class="img-fluid" alt="Excavator">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="#"></a>
                            </div>
                        </div>
                        <div class="pbminfotech-box-content">
                            <h3 class="pbmit-team-title"><a href="#">Excavator</a></h3>
                            <div class="pbminfotech-box-team-position">For deep excavation, trenching & heavy earthworks</div>
                        </div>
                    </div>
                </article>

                <!-- Slide 2 – Payloader -->
                <article class="pbmit-team-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-featured-wrap">
                            <!-- <div class="pbmit-team-btn">
                                <a class="pbmit-team-text" href="#"><i class="pbmit-base-icon-share"></i></a>
                            </div> -->
                            <div class="pbmit-featured-inner">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/payloader.jpg" class="img-fluid" alt="Payloader">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="#"></a>
                            </div>
                        </div>
                        <div class="pbminfotech-box-content">
                            <h3 class="pbmit-team-title"><a href="#">Payloader</a></h3>
                            <div class="pbminfotech-box-team-position">Ideal for loading materials & site clearing</div>
                        </div>
                    </div>
                </article>

                <!-- Slide 3 – Grader -->
                <article class="pbmit-team-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-featured-wrap">
                            <!-- <div class="pbmit-team-btn">
                                <a class="pbmit-team-text" href="#"><i class="pbmit-base-icon-share"></i></a>
                            </div> -->
                            <div class="pbmit-featured-inner">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/grader.jpg" class="img-fluid" alt="Grader">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="#"></a>
                            </div>
                        </div>
                        <div class="pbminfotech-box-content">
                            <h3 class="pbmit-team-title"><a href="#">Grader</a></h3>
                            <div class="pbminfotech-box-team-position">Used for leveling, grading & road finishing</div>
                        </div>
                    </div>
                </article>

                <!-- Slide 4 – Vibrating Roller -->
                <article class="pbmit-team-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-featured-wrap">
                            <!-- <div class="pbmit-team-btn">
                                <a class="pbmit-team-text" href="#"><i class="pbmit-base-icon-share"></i></a>
                            </div> -->
                            <div class="pbmit-featured-inner">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/Vibrating_Roller.png" class="img-fluid" alt="Vibrating Roller">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="#"></a>
                            </div>
                        </div>
                        <div class="pbminfotech-box-content">
                            <h3 class="pbmit-team-title"><a href="#">Vibrating Roller</a></h3>
                            <div class="pbminfotech-box-team-position">For soil compaction & road construction</div>
                        </div>
                    </div>
                </article>

                <!-- Slide 5 – Crane -->
                <article class="pbmit-team-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-featured-wrap">
                            <!-- <div class="pbmit-team-btn">
                                <a class="pbmit-team-text" href="#"><i class="pbmit-base-icon-share"></i></a>
                            </div> -->
                            <div class="pbmit-featured-inner">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/crane-construction-site.jpg" class="img-fluid" alt="Crane">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="#"></a>
                            </div>
                        </div>
                        <div class="pbminfotech-box-content">
                            <h3 class="pbmit-team-title"><a href="#">Crane</a></h3>
                            <div class="pbminfotech-box-team-position">Heavy lifting for industrial & construction projects</div>
                        </div>
                    </div>
                </article>

                <!-- Slide 6 – Lowbed -->
                <article class="pbmit-team-style-1 swiper-slide">
                    <div class="pbminfotech-post-item">
                        <div class="pbmit-featured-wrap">
                            <!-- <div class="pbmit-team-btn">
                                <a class="pbmit-team-text" href="#"><i class="pbmit-base-icon-share"></i></a>
                            </div> -->
                            <div class="pbmit-featured-inner">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/low_bed.jpeg" class="img-fluid" alt="Lowbed Trailer">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="#"></a>
                            </div>
                        </div>
                        <div class="pbminfotech-box-content">
                            <h3 class="pbmit-team-title"><a href="#">Lowbed Trailer (70 Tons)</a></h3>
                            <div class="pbminfotech-box-team-position">Transporting heavy equipment safely</div>
                        </div>
                    </div>
                </article>

            </div>
        </div>

        <div class="pbmit-bottom-text">
            Explore our full fleet of machines. <a href="#"><u>View All Equipment</u></a>
        </div>
    </div>
</section>
<!-- Team End -->

<!-- Quote Form Start -->
<section class="section-md bg-light">
    <div class="container">
        <div class="row align-items-center mb-4">
            <div class="col-md-12">
                <div class="pbmit-heading-subheading text-center">
                    <h4 class="pbmit-subtitle">Request a Quote</h4>
                    <h2 class="pbmit-title">Enquire About Our Machines</h2>
                </div>
            </div>
        </div>
        
        <div class="row justify-content-center">
            <div class="col-md-10">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('message')); ?>

                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <form wire:submit.prevent="submitQuote" class="contact-form left-box">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label class="form-label" style="font-weight: 600; color: #1a1a1a;">Select Machines (Multiple)</label>
                            <div class="p-3 border rounded bg-white" style="max-height: 200px; overflow-y: auto;">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $machines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $machine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="checkbox" wire:model.live="selected_machines" value="<?php echo e($machine['title']); ?>" id="home-machine-<?php echo e($machine['id']); ?>">
                                        <label class="form-check-label" for="home-machine-<?php echo e($machine['id']); ?>">
                                            <?php echo e($machine['title']); ?> <small class="text-muted">(<?php echo e($machine['category']); ?>)</small>
                                        </label>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['selected_machines'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger d-block mt-1"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>

                        <div class="col-md-12 mb-3" x-show="$wire.selected_machines.length > 0">
                             <strong>Selected:</strong>
                             <span x-text="$wire.selected_machines.join(', ')"></span>
                        </div>

                        <div class="col-md-6">
                            <input type="text" class="form-control" placeholder="Full Name *" wire:model="name" required>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="col-md-6">
                            <input type="email" class="form-control" placeholder="Your Email *" wire:model="email" required>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="col-md-12">
                            <input type="text" class="form-control" placeholder="Your Phone *" wire:model="phone" required>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="col-md-12">
                            <textarea wire:model="message" cols="40" rows="5" class="form-control" placeholder="Project Details / Additional Comments *" required></textarea>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="col-md-12 mt-3 text-center">
                            <button type="submit" class="pbmit-btn">
                                <span class="pbmit-button-content-wrapper">
                                    <span class="pbmit-button-icon">
                                        <i class="pbmit-induyst-icon pbmit-induyst-icon-next"></i>
                                    </span>
                                    <span class="pbmit-button-text">Request Quote</span>
                                </span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
<!-- Quote Form End -->


<!-- Testimonial Start --> 
<section class="testimonial-section-one pbmit-bg-color-blackish" data-aos="zoom-in" data-aos-duration="800">
    <div class="container-fluid p-0">
     
        <div class="testimonial-area">
            <div class="row g-0 align-items-center">

                <!-- LEFT COLUMN -->
                <div class="col-md-12 col-xl-4 left-col">
                    <div class="pbmit-heading-subheading">
                        <h4 class="pbmit-subtitle">Why Clients Trust Us</h4>
                    </div>

                    <div class="pbminfotech-ele-fid-style-3">
                        <div class="pbmit-fld-contents">
                            <div class="pbmit-fid-icon">
                                <div class="pbmit-fid-icon-wrapper pbmit-icon-type-icon">
                                    <i class="fas fa-trophy"></i>
                                </div>
                            </div>

                            <div class="pbmit-fld-wrap">
                                <div class="pbmit-fid-inner">
                                    <span class="pbmit-fid-before"></span>
                                    <span class="pbmit-number-rotate numinate" data-appear-animation="animateDigits" data-from="0" data-to="200" data-interval="100">200</span>
                                    <span class="pbmit-fid"><sup>+</sup></span>
                                </div>
                                <h2 class="pbmit-fid-title"></h2>
                                <div class="pbmit-heading-desc">Successful projects supported with our machines and engineering services</div>
                            </div>
                        </div>
                    </div>

                    <!-- CLIENT LOGOS (unchanged structure) -->
                    <div class="swiper-slider" data-autoplay="true" data-loop="true" data-dots="false" data-arrows="false" data-columns="3" data-margin="30">
                        <div class="swiper-wrapper">
                            <!-- logos remain unchanged -->
                        </div>
                    </div>
                </div>

                <!-- RIGHT COLUMN -->
                <div class="col-md-12 col-xl-8">
                    <div class="right-box">
                        <div class="row">

                            <!-- <div class="col-md-12 col-lg-4">
                                <div class="pbmit-heading-subheading">
                                    <h4 class="pbmit-subtitle">Client Testimonials</h4>
                                </div>
                          
                            </div> -->

                            <!-- TESTIMONIAL SLIDER -->
                            <div class="col-md-12 ">
                                <div class="pbmit-heading-subheading">
                                    <h4 class="pbmit-subtitle">Client Testimonials</h4>
                                </div>
                                <div class="swiper-slider" data-autoplay="false" data-loop="false" data-dots="true" data-columns="1" data-margin="30">

                                    <div class="swiper-wrapper">

                                        <!-- Testimonial 1 -->
                                        <article class="pbmit-testimonial-style-2 swiper-slide">
                                            <div class="pbminfotech-post-item">
                                                <blockquote class="pbminfotech-testimonial-text">
                                                    <p>The excavators and payloaders we leased were in excellent condition. Their team ensured fast delivery and reliable on-site support throughout our road construction project.</p>
                                                </blockquote>
                                                <div class="pbminfotech-box-author d-block text-center">
                                                    <div class="pbmit-featured-img-wrapper mb-3 mx-auto" style="width: 80px; height: 80px;">
                                                        <img src="/assets/images/homepage-1/testimonial/testimonial-img-01.jpg" class="img-fluid rounded-circle w-100 h-100 object-fit-cover" alt="">
                                                    </div>
                                                    <div class="pbmit-auther-content">
                                                        <h3 class="pbminfotech-box-title">Engr. Emmanuel Okoro</h3>
                                                        <div class="pbminfotech-testimonial-detail">Site Engineer</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </article>

                                        <!-- Testimonial 2 -->
                                        <article class="pbmit-testimonial-style-2 swiper-slide">
                                            <div class="pbminfotech-post-item">
                                                <blockquote class="pbminfotech-testimonial-text">
                                                    <p>They handled our logistics and heavy-duty haulage professionally. The lowbed transport service was seamless and the operators were well-trained and experienced.</p>
                                                </blockquote>
                                                <div class="pbminfotech-box-author d-block text-center">
                                                    <div class="pbmit-featured-img-wrapper mb-3 mx-auto" style="width: 80px; height: 80px;">
                                                        <img src="/assets/images/homepage-1/testimonial/testimonial-img-02.jpg" class="img-fluid rounded-circle w-100 h-100 object-fit-cover" alt="">
                                                    </div>
                                                    <div class="pbmit-auther-content">
                                                        <h3 class="pbminfotech-box-title">Grace Edebiri</h3>
                                                        <div class="pbminfotech-testimonial-detail">Procurement Manager</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </article>

                                        <!-- Testimonial 3 -->
                                        <article class="pbmit-testimonial-style-2 swiper-slide">
                                            <div class="pbminfotech-post-item">
                                                <blockquote class="pbminfotech-testimonial-text">
                                                    <p>Our drainage and civil works project was completed on schedule thanks to their machines and highly coordinated technical team. Very reliable service.</p>
                                                </blockquote>
                                                <div class="pbminfotech-box-author d-block text-center">
                                                    <div class="pbmit-featured-img-wrapper mb-3 mx-auto" style="width: 80px; height: 80px;">
                                                        <img src="/assets/images/homepage-1/testimonial/testimonial-img-03.jpg" class="img-fluid rounded-circle w-100 h-100 object-fit-cover" alt="">
                                                    </div>
                                                    <div class="pbmit-auther-content">
                                                        <h3 class="pbminfotech-box-title">Matthew Johnson</h3>
                                                        <div class="pbminfotech-testimonial-detail">Project Contractor</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </article>

                                    </div>

                                </div>
                            </div>

                        </div> <!-- row -->
                    </div> <!-- right-box -->
                </div>

            </div>
        </div>
    </div>
</section>
<!-- Testimonial end --> 




<!-- Accordion Start -->
<section class="accordion-section-one pbmit-bg-color-light fade-section">
    <div class="container-fluid p-0">
        <div class="row g-0">

            <div class="col-md-4 first-col">
                <div class="accordion-img"></div>
            </div>

            <div class="col-md-8 second-col">
                <div class="accordion-one-right-box">
                    <div class="row">

                        <!-- LEFT TEXT -->
                        <div class="col-md-12 col-xl-6 left-col">
                            <div class="pbmit-heading-subheading">
                                <h4 class="pbmit-subtitle">To know more about us</h4>
                                <h2 class="pbmit-title">Frequently Asked Questions</h2>
                                <div class="pbmit-heading-desc">Didn't find what you need? Our support team is ready to help.</div>
                            </div>

                            <div class="pbmit-ihbox-style-3">
                                <div class="pbmit-ihbox-box">
                                    <div class="pbmit-ihbox-icon">
                                        <div class="pbmit-ihbox-icon-wrapper pbmit-icon-type-icon">
                                            <i class="fas fa-headset"></i>
                                        </div>
                                    </div>

                                    <div class="pbmit-ihbox-contents">
                                        <div class="pbmit-heading-desc">Ask Questions</div>
                                        <h2 class="pbmit-element-title">
                                            <a class="pbmit-button-inner" href="tel:+2349095557523">
                                                <span class="pbmit-button-content-wrapper">
                                                    <span class="pbmit-button-text">+234 909 555 7523</span>
                                                </span>
                                            </a>
                                        </h2>

                                        <h4 class="pbmit-element-subtitle">
                                            <a class="pbmit-button-inner" href="#">
                                                <span class="pbmit-button-text">info@dumescoastal.com</span>
                                            </a>
                                        </h4>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <!-- ACCORDION -->
                        <div class="col-md-12 col-xl-6">
                            <div class="accordion" id="accordionExample1">

                                <!-- FAQ 1 -->
                                <div class="accordion-item active" id="headingOne1">
                                    <h2 class="accordion-header">
                                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseOne1">
                                            <span class="pbmit-accordion-title">01. What equipment do you lease?</span>
                                            <span class="pbmit-accordion-icon"><i class="fas fa-chevron-down"></i></span>
                                        </button>
                                    </h2>
                                    <div id="collapseOne1" class="accordion-collapse collapse show">
                                        <div class="accordion-body">
                                            We lease excavators, payloaders, graders, vibrating rollers, cranes, and lowbeds (70–120 tons) suitable for construction, engineering, and industrial operations.
                                        </div>
                                    </div>
                                </div>

                                <!-- FAQ 2 -->
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingTwo1">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseTwo1">
                                            <span class="pbmit-accordion-title">02. Do you provide operators?</span>
                                            <span class="pbmit-accordion-icon"> ... </span>
                                        </button>
                                    </h2>
                                    <div id="collapseTwo1" class="accordion-collapse collapse">
                                        <div class="accordion-body">
                                            Yes. All our machines come with trained and certified operators for safe and efficient project execution.
                                        </div>
                                    </div>
                                </div>

                                <!-- FAQ 3 -->
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingThree1">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseThree1">
                                            <span class="pbmit-accordion-title">03. Do you handle logistics and haulage?</span>
                                            <span class="pbmit-accordion-icon"> ... </span>
                                        </button>
                                    </h2>
                                    <div id="collapseThree1" class="accordion-collapse collapse">
                                        <div class="accordion-body">
                                            We offer full logistics support including heavy-duty haulage, lowbed transport, and on-site equipment movement.
                                        </div>
                                    </div>
                                </div>

                                <!-- FAQ 4 -->
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingFour1">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                            data-bs-target="#collapseFour1">
                                            <span class="pbmit-accordion-title">04. What civil works services do you offer?</span>
                                            <span class="pbmit-accordion-icon"> ... </span>
                                        </button>
                                    </h2>
                                    <div id="collapseFour1" class="accordion-collapse collapse">
                                        <div class="accordion-body">
                                            We execute road construction, drainage systems, erosion control, site preparation, and solar streetlight installation with industry-standard precision.
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div> <!-- row -->
                </div> <!-- right-box -->
            </div>
        </div>
    </div>
</section>
<!-- Accordion End -->

<!-- Blog start -->
<!-- <section class="section-md blog-section-one" data-aos="fade-up" data-aos-duration="800">
    <div class="container">
        <div class="pbmit-heading-subheading text-center">
            <h4 class="pbmit-subtitle">Fresh News</h4>
            <h2 class="pbmit-title">Articles & blog posts with <br> useful information</h2>
        </div>
        <div class="row pbminfotech-gap-10px">
            <div class="col-md-12 col-lg-7 pbmit-blog-group-left">
                <article class="pbmit-blog-style-2">
                    <div class="post-item">
                        <div class="pbminfotech-box-content">
                            <div class="pbmit-featured-container">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/blog/blog-img-01.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="blog-single-details.html"></a>
                            </div>
                            <div class="pbmit-content-wrapper">
                                <div class= "pbmit-meta-wraper d-flex align-items-center">
                                    <div class="pbmit-meta-category-wrapper pbmit-meta-line">
                                        <div class="pbmit-meta-category">
                                            <a href="blog-classic.html" rel="category tag">Logistics</a>
                                        </div>
                                    </div>
                                    <div class="pbmit-meta-date-wrapper pbmit-meta-line">
                                        <span class="pbmit-post-date">6  Feb 2025</span>
                                    </div>
                                </div>
                                <h3 class="pbmit-post-title">
                                    <a href="blog-single-details.html">The Future of Technology in Urban Development</a>
                                </h3>
                                <div class="pbmit-blog-btn">
                                    <a class="pbmit-button-inner" href="blog-single-details.html">
                                        <span class="pbmit-button-text">Read More</span>
                                        <i class="pbmit-base-icon-right-arrow"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
            <div class="col-md-12 col-lg-5 pbmit-blog-group-right">
                <article class="pbmit-blog-style-2">
                    <div class="post-item">
                        <div class="pbminfotech-box-content">
                            <div class="pbmit-featured-container">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/blog/blog-img-01.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="blog-single-details.html"></a>
                            </div>
                            <div class="pbmit-content-wrapper">
                                <div class= "pbmit-meta-wraper d-flex align-items-center">
                                    <div class="pbmit-meta-category-wrapper pbmit-meta-line">
                                        <div class="pbmit-meta-category">
                                            <a href="blog-classic.html" rel="category tag">Engineering</a>
                                        </div>
                                    </div>
                                    <div class="pbmit-meta-date-wrapper pbmit-meta-line">
                                        <span class="pbmit-post-date">6  Feb 2025</span>
                                    </div>
                                </div>
                                <h3 class="pbmit-post-title">
                                    <a href="blog-single-details.html">U.S. fund managers trim bank stocks on profit worries</a>
                                </h3>
                                <div class="pbmit-blog-btn">
                                    <a class="pbmit-button-inner" href="blog-single-details.html">
                                        <span class="pbmit-button-text">Read More</span>
                                        <i class="pbmit-base-icon-right-arrow"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </article>
                <article class="pbmit-blog-style-2">
                    <div class="post-item">
                        <div class="pbminfotech-box-content">
                            <div class="pbmit-featured-container">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/blog/blog-img-01.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="blog-single-details.html"></a>
                            </div>
                            <div class="pbmit-content-wrapper">
                                <div class= "pbmit-meta-wraper d-flex align-items-center">
                                    <div class="pbmit-meta-category-wrapper pbmit-meta-line">
                                        <div class="pbmit-meta-category">
                                            <a href="blog-classic.html" rel="category tag">Construction</a>
                                        </div>
                                    </div>
                                    <div class="pbmit-meta-date-wrapper pbmit-meta-line">
                                        <span class="pbmit-post-date">6  Feb 2025</span>
                                    </div>
                                </div>
                                <h3 class="pbmit-post-title">
                                    <a href="blog-single-details.html">Role of Architecture in Disaster Relief and Resilience</a>
                                </h3>
                                <div class="pbmit-blog-btn">
                                    <a class="pbmit-button-inner" href="blog-single-details.html">
                                        <span class="pbmit-button-text">Read More</span>
                                        <i class="pbmit-base-icon-right-arrow"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </article>
                <article class="pbmit-blog-style-2">
                    <div class="post-item">
                        <div class="pbminfotech-box-content">
                            <div class="pbmit-featured-container">
                                <div class="pbmit-featured-img-wrapper">
                                    <div class="pbmit-featured-wrapper">
                                        <img src="/assets/images/homepage-1/blog/blog-img-01.jpg" class="img-fluid" alt="">
                                    </div>
                                </div>
                                <a class="pbmit-link" href="blog-single-details.html"></a>
                            </div>
                            <div class="pbmit-content-wrapper">
                                <div class= "pbmit-meta-wraper d-flex align-items-center">
                                    <div class="pbmit-meta-category-wrapper pbmit-meta-line">
                                        <div class="pbmit-meta-category">
                                            <a href="blog-classic.html" rel="category tag">Industrial</a>
                                        </div>
                                    </div>
                                    <div class="pbmit-meta-date-wrapper pbmit-meta-line">
                                        <span class="pbmit-post-date">6  Feb 2025</span>
                                    </div>
                                </div>
                                <h3 class="pbmit-post-title">
                                    <a href="blog-single-details.html">Importance of Quality and Testing in Modern Factories</a>
                                </h3>
                                <div class="pbmit-blog-btn">
                                    <a class="pbmit-button-inner" href="blog-single-details.html">
                                        <span class="pbmit-button-text">Read More</span>
                                        <i class="pbmit-base-icon-right-arrow"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
        </div>
    </div>
</section> -->
<!-- Blog End -->

</div>
<!-- page content End -->
</div>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/Dumes/resources/views/livewire/home-component.blade.php ENDPATH**/ ?>