<div>
    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner container">
                            <h1 class="pbmit-tbar-title"> Our Machines</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span>
                                <a title="" href="<?php echo e(route('home')); ?>" class="home"><span>Home</span></a>
                            </span>
                            <span class="sep"></span>
                            <span><span class="post-root post post-post current-item"> Machines</span></span>
                        </div>
                    </div>
                </div>
            </div> 
        </div> 
    </div>
    <!-- Title Bar End-->

    <div class="page-content">  
        <!-- Machines Grid -->
        <section class="section-md">
            <div class="container">
                <div class="pbmit-heading-subheading text-center mb-5">
                    <h4 class="pbmit-subtitle">Our Fleet</h4>
                    <h2 class="pbmit-title">Select Machines for Your Quote</h2>
                    <p>Tick the checkbox on the machines you are interested in, then fill out the form below.</p>
                </div>

                <!-- Sidebar Filter -->
                <div class="row mb-5">
                 

                    <div class="col-md-12">
                        <div class="row pbmit-element-posts-wrapper">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $machines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $machine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <article class="pbmit-portfolio-style-1 col-md-6 col-lg-4 mb-4" wire:key="machine-<?php echo e($machine->id); ?>" x-data="{ showShare: false }">
                                <div class="pbminfotech-post-content">
                                    <div class="pbminfotech-post-warpper">
                                        <div class="pbmit-featured-img-wrapper">
                                            <div class="pbmit-featured-wrapper">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(str_contains($machine->image, 'http')): ?>
                                                    <img src="<?php echo e($machine->image); ?>" class="img-fluid" alt="<?php echo e($machine->name); ?>" style="height: 250px; object-fit: cover; width: 100%;">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/images/equipment')); ?>/<?php echo e($machine->image); ?>" class="img-fluid" alt="<?php echo e($machine->name); ?>" style="height: 250px; object-fit: cover; width: 100%;">
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </div>
                                        <!-- <label class="pbmit-link-label" style="position: absolute; top: 10px; right: 10px; z-index: 10; cursor: pointer;">
                                            <input type="checkbox" wire:model.live="selected_machines" value="<?php echo e($machine->name); ?>" style="transform: scale(1.5);">
                                        </label> -->

                                        <!-- Share Trigger Button -->
                                        <button type="button" @click="showShare = !showShare" style="position: absolute; bottom: 10px; right: 10px; z-index: 20; background: white; border: none; border-radius: 50%; width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 5px rgba(0,0,0,0.2); cursor: pointer;" title="Share">
                                            <i class="fas fa-share-alt" style="color: #333;"></i>
                                        </button>
                                        
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($machine->status == 'rented'): ?>
                                            <div style="position: absolute; top: 10px; left: 10px; z-index: 10;">
                                                <span class="badge bg-warning text-dark">Rented</span>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-titlebox">
                                            <div class="pbmit-port-cat">
                                                <a href="#" rel="tag"><?php echo e($machine->category->name ?? 'Uncategorized'); ?></a>
                                            </div>
                                            <h3 class="pbmit-portfolio-title">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <a href="#" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo e($machine->description); ?>"><?php echo e($machine->name); ?></a>
                                                </div>
                                            </h3>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($machine->pricing): ?>
                                                <div class="text-primary fw-bold mt-1">$<?php echo e(number_format($machine->pricing, 2)); ?></div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            <div class="form-check mt-2">
                                                <input class="form-check-input" type="checkbox" wire:model.live="selected_machines" value="<?php echo e($machine->name); ?>" id="check-<?php echo e($machine->id); ?>">
                                                <label class="form-check-label" for="check-<?php echo e($machine->id); ?>" style="font-size: 14px; font-weight: normal;">
                                                    Select for Quote
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Share Popup Modal (Bottom Right of Card) -->
                                    <div x-show="showShare" @click.away="showShare = false" style="display: none; position: absolute; bottom: 60px; right: 10px; z-index: 999; background: white; padding: 15px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.2); width: 250px;" x-transition>
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <h6 class="m-0" style="font-size: 14px; font-weight: 600;">Share</h6>
                                            <button type="button" @click="showShare = false" style="background: none; border: none; font-size: 16px; cursor: pointer; color: #999;">&times;</button>
                                        </div>
                                        
                                        <div class="d-flex gap-2 justify-content-center mb-3">
                                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(route('machines'))); ?>" target="_blank" class="btn btn-sm btn-light rounded-circle" style="width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; color: #3b5998;"><i class="fab fa-facebook-f"></i></a>
                                            <a href="https://twitter.com/intent/tweet?text=<?php echo e(urlencode('Check out ' . $machine->name)); ?>&url=<?php echo e(urlencode(route('machines'))); ?>" target="_blank" class="btn btn-sm btn-light rounded-circle" style="width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; color: #1da1f2;"><i class="fab fa-twitter"></i></a>
                                            <a href="https://wa.me/?text=<?php echo e(urlencode('Check out ' . $machine->name . ': ' . $machine->description)); ?>" target="_blank" class="btn btn-sm btn-light rounded-circle" style="width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; color: #25d366;"><i class="fab fa-whatsapp"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </article>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="col-12 text-center py-5">
                                    <h4>No machines found matching your criteria.</h4>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <div class="mt-4">
                            <?php echo e($machines->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Machines Grid End -->

        <!-- Quote Form -->
        <section class="contact-us-section section-md bg-light">
            <div class="container">
                <div class="row align-items-center mb-4">
                    <div class="col-md-12">
                        <div class="pbmit-heading-subheading text-center">
                            <h4 class="pbmit-subtitle">Request a Quote</h4>
                            <h2 class="pbmit-title">Get a Custom Quote for Selected Machines</h2>
                        </div>
                    </div>
                </div>
                
                <div class="row justify-content-center">
                    <div class="col-md-10">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('message')); ?>

                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <form wire:submit.prevent="submitQuote" class="contact-form left-box">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="p-3 border rounded bg-white">
                                        <strong>Selected Machines:</strong>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(empty($selected_machines)): ?>
                                            <span class="text-muted fst-italic">No machines selected yet. Please select from the list above.</span>
                                        <?php else: ?>
                                            <ul class="list-inline d-inline mb-0">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $selected_machines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selected): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="list-inline-item badge bg-primary text-white"><?php echo e($selected); ?></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </ul>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['selected_machines'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger d-block mt-1"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="Full Name *" wire:model="name" required>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <div class="col-md-6">
                                    <input type="email" class="form-control" placeholder="Your Email *" wire:model="email" required>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" placeholder="Your Phone *" wire:model="phone" required>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <div class="col-md-12">
                                    <textarea wire:model="message" cols="40" rows="5" class="form-control" placeholder="Project Details / Additional Comments *" required></textarea>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['message'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                                <div class="col-md-12 mt-3 text-center">
                                    <button type="submit" class="pbmit-btn">
                                        <span class="pbmit-button-content-wrapper">
                                            <span class="pbmit-button-icon">
                                                <i class="pbmit-induyst-icon pbmit-induyst-icon-next"></i>
                                            </span>
                                            <span class="pbmit-button-text">Request Quote</span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!-- Quote Form End -->

    </div>
</div>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/Dumes/resources/views/livewire/machines-component.blade.php ENDPATH**/ ?>