<div>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('message')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('message')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Healthcare Job Applications</h5>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-applications">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Surname</th>
                                    <th>First Name</th>
                                    <th>Previous Surnames</th>
                                    <th>Previous Surnames Evidence</th>
                                    <th>Telephone Number</th>
                                    <th>Email</th>
                                    <th>Position Applied For</th>
                                    <th>Location</th>
                                    <th>Work Preference</th>
                                    <th>Hours Requested</th>
                                    <th>Understands Role</th>
                                    <th>Availability</th>
                                    <th>Address</th>
                                    <th>Postcode</th>
                                    <th>Mobile Number</th>
                                    <th>NI Number</th>
                                    <th>Gender</th>
                                    <th>Is Driver</th>
                                    <th>Own Transport</th>
                                    <th>Licence Duration</th>
                                    <th>Endorsements</th>
                                    <th>UK National</th>
                                    <th>Visa Details</th>
                                    <th>Is Related</th>
                                    <th>Reasonable Adjustments</th>
                                    <th>Education</th>
                                    <th>Training</th>
                                    <th>Memberships</th>
                                    <th>Employment</th>
                                    <th>Gaps Explanation</th>
                                    <th>Referee 1</th>
                                    <th>Referee 2</th>
                                    <th>Unspent Convictions</th>
                                    <th>Unspent Cautions</th>
                                    <th>Print Full Name</th>
                                    <th>Identity Proof</th>
                                    <th>Copy Passport Proof</th>
                                    <th>Drivers Licence Proof</th>
                                    <th>Bank Account Proof</th>
                                    <th>Qualifications Proof</th>
                                    <th>Current Address Proof</th>
                                    <th>NINO Proof Attachment</th>
                                    <th>Passport Sized Photo</th>
                                    <th>Current DBS Proof</th>
                                    <th>Statement of Entry Proof</th>
                                    <th>Mandatory Training Proof</th>
                                    <th>Signature</th>
                                    <th>Date</th>
                                    <th>Created At</th>
                                    <th>Updated At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $applications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $application): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($application->id); ?></td>
                                        <td><?php echo e($application->surname); ?></td>
                                        <td><?php echo e($application->firstname); ?></td>
                                        <td><?php echo e($application->previous_surnames); ?></td>
                                        <td><?php echo e($application->previous_surnames_evidence); ?></td>
                                        <td><?php echo e($application->telephone_number); ?></td>
                                        <td><?php echo e($application->your_email); ?></td>
                                        <td><?php echo e($application->position_applied_for); ?></td>
                                        <td><?php echo e($application->location); ?></td>
                                        <td><?php echo e($application->work_preference); ?></td>
                                        <td><?php echo e($application->hours_requested); ?></td>
                                        <td><?php echo e($application->understands_role); ?></td>
                                        <td><?php echo e(json_encode($application->availability)); ?></td>
                                        <td><?php echo e($application->address); ?></td>
                                        <td><?php echo e($application->postcode); ?></td>
                                        <td><?php echo e($application->mobile_number); ?></td>
                                        <td><?php echo e($application->ni_number); ?></td>
                                        <td><?php echo e($application->gender); ?></td>
                                        <td><?php echo e($application->is_driver); ?></td>
                                        <td><?php echo e($application->own_transport); ?></td>
                                        <td><?php echo e($application->licence_duration); ?></td>
                                        <td><?php echo e($application->endorsements); ?></td>
                                        <td><?php echo e($application->uk_national); ?></td>
                                        <td><?php echo e($application->visa_details); ?></td>
                                        <td><?php echo e($application->is_related); ?></td>
                                        <td><?php echo e($application->reasonable_adjustments); ?></td>
                                        <td><?php echo e(json_encode($application->education)); ?></td>
                                        <td><?php echo e(json_encode($application->training)); ?></td>
                                        <td><?php echo e(json_encode($application->memberships)); ?></td>
                                        <td><?php echo e(json_encode($application->employment)); ?></td>
                                        <td><?php echo e($application->gaps_explanation); ?></td>
                                        <td><?php echo e(json_encode($application->referee1)); ?></td>
                                        <td><?php echo e(json_encode($application->referee2)); ?></td>
                                        <td><?php echo e($application->unspent_convictions); ?></td>
                                        <td><?php echo e($application->unspent_cautions); ?></td>
                                        <td><?php echo e($application->print_full_name); ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->identity_proof): ?><a href="<?php echo e($application->identity_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->copy_passport_proof): ?><a href="<?php echo e($application->copy_passport_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->drivers_licence_proof): ?><a href="<?php echo e($application->drivers_licence_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->bank_account_proof): ?><a href="<?php echo e($application->bank_account_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->qualifications_proof): ?><a href="<?php echo e($application->qualifications_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->current_address_proof): ?><a href="<?php echo e($application->current_address_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->nino_proof_attachment): ?><a href="<?php echo e($application->nino_proof_attachment); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->passport_sized_photo): ?><a href="<?php echo e($application->passport_sized_photo); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->current_dbs_proof): ?><a href="<?php echo e($application->current_dbs_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->statement_of_entry_proof): ?><a href="<?php echo e($application->statement_of_entry_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($application->mandatory_training_proof): ?><a href="<?php echo e($application->mandatory_training_proof); ?>" target="_blank">View</a><?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?></td>
                                        <td><?php echo e($application->signature); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($application->date)->format('M d, Y')); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($application->created_at)->format('M d, Y H:i:s')); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($application->updated_at)->format('M d, Y H:i:s')); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        <?php echo e($applications->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
        <script>
            document.addEventListener('livewire:initialized', function () {
                const dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                    searchable: true,
                    fixedHeight: true,
                    perPage: <?php echo e($perPage); ?>,
                    perPageSelect: [5, 10, 25, 50],
                    labels: {
                        placeholder: "Search...",
                        perPage: "{select} entries per page",
                        noRows: "No entries found",
                        info: "Showing {start} to {end} of {rows} entries"
                    }
                });

                Livewire.on('tableUpdated', () => {
                    dataTableSearch.destroy();
                    dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                        searchable: true,
                        fixedHeight: true,
                        perPage: <?php echo e($perPage); ?>,
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                    });
                });
            });
        </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/Dumes/resources/views/livewire/admin/admin-healthcare-job-application-component.blade.php ENDPATH**/ ?>