<div>
    <!-- Include Bootstrap and DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">

    <div class="container-fluid py-2">
        <div class="row mt-4">
            <div class="col-12">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('message')): ?>
                <div class="alert alert-success alert-dismissible fade show text-white" role="alert">
                    <?php echo e(session('message')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show text-white" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <div class="card">
                    <!-- Card header -->
                    <div class="card-header d-flex justify-content-between">
                        <h5 class="mb-0">All Blog Categories</h5>
                        <button wire:click="openModal" class="btn btn-primary-custom py-2 px-3">Add New Category</button>
                    </div>

                    <!-- Modal -->
                    <div wire:ignore.self class="modal fade" id="exampleModal" tabindex="-1" role="dialog" 
                         aria-labelledby="exampleModalLabel" aria-hidden="<?php echo e($showModal ? 'false' : 'true'); ?>">
                        <div class="modal-dialog modal-dialog-centered" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title font-weight-normal" id="exampleModalLabel">
                                        <?php echo e($isEdit ? 'Edit Category' : 'Add Category'); ?>

                                    </h5>
                                    <button type="button" class="btn-close text-dark" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                   
                                    <div class="mb-3">
                                        <label class="form-label fw-semibold">Name</label>
                                        <input wire:model="name" type="text" class="form-control border p-2" placeholder="Enter category name">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mt-1 small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="button" wire:click="save" class="btn bg-primary text-white">Save changes</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-search">
                            <thead class="thead-light">
                                <tr>
                                    <th class="text-center">Name</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="text-sm font-weight-normal text-center "><?php echo e($category->name); ?></td>
                                        <td class="text-sm text-center font-weight-normal">
                                            <!-- Edit Icon -->
                                            <a href="#" wire:click="openModal(<?php echo e($category->id); ?>)"
                                               class="btn btn-sm btn-icon-only text-light" 
                                               data-toggle="tooltip" 
                                               data-original-title="Edit category">
                                                <i class="bi bi-pencil fs-6 text-primary-custom"></i>
                                            </a>
                                            <!-- Delete Icon -->
                                            <a href="#" wire:click="delete(<?php echo e($category->id); ?>)"
                                               class="btn btn-sm btn-icon-only text-light" 
                                               data-toggle="tooltip" 
                                               data-original-title="Delete category">
                                                <i class="bi bi-trash fs-6 text-danger"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <?php $__env->startPush('scripts'); ?>
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
            <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
            <script>
                document.addEventListener('livewire:initialized', function () {
                    const dataTableSearch = new simpleDatatables.DataTable("#datatable-search", {
                        searchable: true,
                        fixedHeight: true,
                        perPage: 10,
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                    });
                });

                window.addEventListener('show-modal', event => {
                    const myModal = new bootstrap.Modal(document.getElementById('exampleModal'));
                    myModal.show();
                });

                window.addEventListener('hide-modal', event => {
                    const myModal = bootstrap.Modal.getInstance(document.getElementById('exampleModal'));
                    if (myModal) {
                        myModal.hide();
                    }
                });
            </script>
        <?php $__env->stopPush(); ?>
    </div>
</div><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/Dumes/resources/views/livewire/admin/admin-category-component.blade.php ENDPATH**/ ?>