<div>
    <?php $__env->startPush('seo_meta'); ?>
        <title><?php echo e($machine->name); ?> - Dumes</title>
        <meta name="description" content="<?php echo e(Str::limit(strip_tags($machine->description), 160)); ?>">
        
        <!-- Open Graph / Facebook -->
        <meta property="og:type" content="product" />
        <meta property="og:url" content="<?php echo e(url()->current()); ?>" />
        <meta property="og:title" content="<?php echo e($machine->name); ?>" />
        <meta property="og:description" content="<?php echo e(Str::limit(strip_tags($machine->description), 200)); ?>" />
        <meta property="og:image" content="<?php echo e(str_contains($machine->image, 'http') ? $machine->image : asset('assets/images/equipment/'.$machine->image)); ?>" />

        <!-- Twitter -->
        <meta property="twitter:card" content="summary_large_image" />
        <meta property="twitter:url" content="<?php echo e(url()->current()); ?>" />
        <meta property="twitter:title" content="<?php echo e($machine->name); ?>" />
        <meta property="twitter:description" content="<?php echo e(Str::limit(strip_tags($machine->description), 200)); ?>" />
        <meta property="twitter:image" content="<?php echo e(str_contains($machine->image, 'http') ? $machine->image : asset('assets/images/equipment/'.$machine->image)); ?>" />
    <?php $__env->stopPush(); ?>

    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper">
		<div class="container">
			<div class="pbmit-title-bar-content">
				<div class="pbmit-title-bar-content-inner">
					<div class="pbmit-tbar">
						<div class="pbmit-tbar-inner container">
							<h1 class="pbmit-tbar-title"> <?php echo e($machine->name); ?></h1>
						</div>
					</div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span><a href="<?php echo e(route('home')); ?>" class="home"><span>Home</span></a></span>
                            <span class="sep"></span>
                            <span><a href="<?php echo e(route('machines')); ?>"><span>Machines</span></a></span>
                            <span class="sep"></span>
                            <span><span class="post-root post post-post current-item"> <?php echo e($machine->name); ?></span></span>
                        </div>
                    </div>
				</div>
			</div> 
		</div> 
	</div>

    <section class="section-md">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 mb-4">
                     <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(str_contains($machine->image, 'http')): ?>
                        <img src="<?php echo e($machine->image); ?>" class="img-fluid w-100 rounded shadow-sm" alt="<?php echo e($machine->name); ?>">
                    <?php else: ?>
                        <img src="<?php echo e(asset('assets/images/equipment')); ?>/<?php echo e($machine->image); ?>" class="img-fluid w-100 rounded shadow-sm" alt="<?php echo e($machine->name); ?>">
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
                <div class="col-lg-6">
                    <h2 class="mb-3"><?php echo e($machine->name); ?></h2>
                    <div class="d-flex align-items-center mb-3">
                        <span class="badge <?php echo e($machine->status == 'available' ? 'bg-success' : ($machine->status == 'rented' ? 'bg-warning' : 'bg-danger')); ?> me-2">
                            <?php echo e(ucfirst($machine->status)); ?>

                        </span>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($machine->category): ?>
                            <span class="text-muted"><i class="bi bi-tag-fill me-1"></i> <?php echo e($machine->category->name); ?></span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                   
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($machine->pricing): ?>
                        <h3 class="text-primary mb-4">$<?php echo e(number_format($machine->pricing, 2)); ?></h3>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <div class="mb-4">
                        <h5 class="border-bottom pb-2">Specifications</h5>
                        <p class="text-muted"><?php echo e($machine->specifications); ?></p>
                    </div>

                    <div class="mb-4">
                        <h5 class="border-bottom pb-2">Description</h5>
                        <p class="text-muted"><?php echo e($machine->description); ?></p>
                    </div>
                    
                    <div class="p-3 bg-light rounded mt-4">
                        <h6 class="mb-3">Share this Machine:</h6>
                        <div class="d-flex gap-2">
                             <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(url()->current()); ?>" target="_blank" class="btn btn-primary btn-sm"><i class="fab fa-facebook-f me-1"></i> Facebook</a>
                             <a href="https://twitter.com/intent/tweet?text=<?php echo e(urlencode('Check out ' . $machine->name)); ?>&url=<?php echo e(url()->current()); ?>" target="_blank" class="btn btn-info text-white btn-sm"><i class="fab fa-twitter me-1"></i> Twitter</a>
                             <a href="https://wa.me/?text=<?php echo e(urlencode('Check out ' . $machine->name . ' at ' . url()->current())); ?>" target="_blank" class="btn btn-success btn-sm"><i class="fab fa-whatsapp me-1"></i> WhatsApp</a>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                         <a href="<?php echo e(route('machines')); ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i> Back to Machines</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/Dumes/resources/views/livewire/machine-detail-component.blade.php ENDPATH**/ ?>