<div>
    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner container">
                            <h1 class="pbmit-tbar-title">{{ $service['title'] }}</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span>
                                <a title="" href="/" class="home"><span>Home</span></a>
                            </span>
                            <span class="sep"></span>
                            <span>
                                <a title="" href="{{ route('services') }}" class="home"><span>Services</span></a>
                            </span>
                            <span class="sep"></span>
                            <span><span class="post-root post post-post current-item">{{ $service['title'] }}</span></span>
                        </div>
                    </div>
                </div>
            </div> 
        </div> 
    </div>
    <!-- Title Bar End-->

    <!-- Page Content -->
    <div class="page-content" id="page">

        <!-- Service Details --> 
        <section class="site-content service-details">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-xl-3 service-left-col sidebar">
                        <aside class="service-sidebar">
                            <aside class="widget post-list">
                                <div class="all-post-list">
                                    <ul>
                                        @foreach($allServices as $s)
                                            <li class="{{ $s['slug'] == $slug ? 'post-active' : '' }}">
                                                <a href="{{ route('service.detail', ['slug' => $s['slug']]) }}"> {{ $s['title'] }} </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            </aside>
                            <aside class="widget pbmit-service-ad">
                                <div class="textwidget">
                                    <div class="pbmit-blog-ads-box">
                                        <h5 class="pbmit-ad-subheading">WE ARE BEST</h5>
                                        <h4 class="pbmit-ad-heading">Construction for <span class="pbmit-global-color"> Better Tomorrow</span></h4>
                                        <div class="pbmit-ad-button">
                                            <a href="tel:+0(123)456-789">
                                                <span class="pbmit-button-text">+234 81 054 263 29</span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </aside>
                            <aside class="widget pbmit-download-info">
                                <h2 class="widget-title">Company profile</h2>
                                <div class="textwidget">
                                    <div class="pbmit-download">
                                        
                                        <div class="pbmit-item-download">
                                            <a href="#" target="_blank" rel="noopener">
                                                <div class="pbmit-download-content">
                                                    <div class="pbmit-download-wrap">
                                                        <i class="pbmit-base-icon-pdf-file"></i>
                                                        <div class="pbmit-title-wrap">
                                                            <h3 class="pbmit-download-title">Download PDF</h3>
                                                        </div>
                                                    </div>
                                                    <span class="pbmit-download-item">
                                                        <i class="pbminfotech-base-icons pbmit-righticon pbmit-base-icon-download"></i>
                                                    </span>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </aside>
                        </aside>
                    </div>
                    <div class="col-md-12 col-xl-9 service-right-col">
                        <div class="pbmit-short-description">
                            <div class="pbmit-custom-heading">
                                <h3 class="pbmit-title">{{ $service['title'] }}</h3>
                            </div>
                            <p>{{ $service['description'] }}</p>
                            <p>{{ $service['long_description'] }}</p>
                        </div>
                        <div class="pbmit-service-feature-image">
                            <img src="{{ $service['image'] }}" class="img-fluid" alt="{{ $service['title'] }}">
                        </div>
                        <div data-aos="fade-up" data-aos-duration="800">
                            <div class="pbmit-custom-heading">
                                <h3 class="pbmit-title">Why Choose This Service</h3>
                            </div>
                            <p class="pb-3">We ensure top-quality delivery, strictly adhering to safety standards and project timelines.</p>
                            
                        </div>
                        <div data-aos="fade-up" data-aos-duration="800">
                            <div class="pbmit-custom-heading">
                                <h3 class="pbmit-title">Key Features</h3>
                            </div>
                            <ul class="list-group">
                                @foreach($service['features'] as $feature)
                                <li class="list-group-item">
                                    <span class="pbmit-icon-list-icon">
                                        <i class="pbmit-base-icon-checkbox"></i>                       
                                    </span>
                                    <span class="pbmit-icon-list-text">{{ $feature }}</span>
                                </li>
                                @endforeach
                            </ul>
                            <div class="row pt-5">
                                <div class="col-md-12 col-xl-6">
                                    <!-- <div class="service-single-02-img"></div> -->
                                    <img src="{{ $service['image'] }}" class="img-fluid rounded" alt="">
                                </div>
                                <div class="col-md-12 col-xl-6 ps-xl-4 mt-xl-0 mt-5">
                                    <div class="pbmit-custom-heading">
                                        <h3 class="pbmit-title">Frequently asked questions</h3>
                                    </div>
                                    <div class="accordion" id="accordionExample1">
                                        <div class="accordion-item active" id="headingOne1">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseOne1" aria-expanded="false" aria-controls="collapseOne1">
                                                        <span class="pbmit-accordion-title">
                                                            01. How do you ensure product quality? 
                                                        </span>
                                                        <span class="pbmit-accordion-icon">
                                                            <span class="pbmit-accordion-icon-opened">
                                                                <i class="fas fa-minus"></i>
                                                            </span>
                                                            <span class="pbmit-accordion-icon-closed">
                                                                <i class="fas fa-plus"></i>
                                                            </span>
                                                        </span>
                                                </button>
                                            </h2>
                                            <div id="collapseOne1" class="accordion-collapse collapse show" aria-labelledby="headingOne1"
                                                data-bs-parent="#accordionExample1">
                                                <div class="accordion-body">
                                                    We maintain strict quality control at every stage of the process, carefully sourcing raw materials to thorough final inspection.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo1">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseTwo1" aria-expanded="false" aria-controls="collapseTwo1">
                                                        <span class="pbmit-accordion-title">
                                                            02. Do you offer customized solutions? 
                                                        </span>
                                                        <span class="pbmit-accordion-icon">
                                                            <span class="pbmit-accordion-icon-opened">
                                                                <i class="fas fa-minus"></i>
                                                            </span>
                                                            <span class="pbmit-accordion-icon-closed">
                                                                <i class="fas fa-plus"></i>
                                                            </span>
                                                        </span>
                                                </button>
                                            </h2>
                                            <div id="collapseTwo1" class="accordion-collapse collapse" aria-labelledby="headingTwo1"
                                                data-bs-parent="#accordionExample1">
                                                <div class="accordion-body">
                                                    Yes, we tailor our services to meet the specific requirements of each project, ensuring optimal results aligned with your goals.
                                                </div>
                                            </div>
                                        </div>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree1">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                    data-bs-target="#collapseThree1" aria-expanded="false" aria-controls="collapseThree1">
                                                        <span class="pbmit-accordion-title">
                                                            03. What sustainability practice to follow?
                                                        </span>
                                                        <span class="pbmit-accordion-icon">
                                                            <span class="pbmit-accordion-icon-opened">
                                                                <i class="fas fa-minus"></i>
                                                            </span>
                                                            <span class="pbmit-accordion-icon-closed">
                                                                <i class="fas fa-plus"></i>
                                                            </span>
                                                        </span>
                                                </button>
                                            </h2>
                                            <div id="collapseThree1" class="accordion-collapse collapse" aria-labelledby="headingThree1"
                                                data-bs-parent="#accordionExample1">
                                                <div class="accordion-body">
                                                    We prioritize eco-friendly practices, including using sustainable materials and energy-efficient technologies like solar power.
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Service Details End -->

    </div>
    <!-- Page Content End -->
</div>
