<div>
    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner container">
                            <h1 class="pbmit-tbar-title"> Our Machines</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span>
                                <a title="" href="{{ route('home') }}" class="home"><span>Home</span></a>
                            </span>
                            <span class="sep"></span>
                            <span><span class="post-root post post-post current-item"> Machines</span></span>
                        </div>
                    </div>
                </div>
            </div> 
        </div> 
    </div>
    <!-- Title Bar End-->

    <div class="page-content">  
        <!-- Machines Grid -->
        <section class="section-md">
            <div class="container">
                <div class="pbmit-heading-subheading text-center mb-5">
                    <h4 class="pbmit-subtitle">Our Fleet</h4>
                    <h2 class="pbmit-title">Select Machines for Your Quote</h2>
                    <p>Tick the checkbox on the machines you are interested in, then fill out the form below.</p>
                </div>

                <!-- Sidebar Filter -->
                <div class="row mb-5">
                 

                    <div class="col-md-12">
                        <div class="row pbmit-element-posts-wrapper">
                            @forelse($machines as $machine)
                            <article class="pbmit-portfolio-style-1 col-md-6 col-lg-4 mb-4" wire:key="machine-{{ $machine->id }}" x-data="{ showShare: false }">
                                <div class="pbminfotech-post-content">
                                    <div class="pbminfotech-post-warpper">
                                        <div class="pbmit-featured-img-wrapper">
                                            <div class="pbmit-featured-wrapper">
                                                @if(str_contains($machine->image, 'http'))
                                                    <img src="{{ $machine->image }}" class="img-fluid" alt="{{ $machine->name }}" style="height: 250px; object-fit: cover; width: 100%;">
                                                @else
                                                    <img src="{{ asset('assets/images/equipment') }}/{{ $machine->image }}" class="img-fluid" alt="{{ $machine->name }}" style="height: 250px; object-fit: cover; width: 100%;">
                                                @endif
                                            </div>
                                        </div>
                                        <!-- <label class="pbmit-link-label" style="position: absolute; top: 10px; right: 10px; z-index: 10; cursor: pointer;">
                                            <input type="checkbox" wire:model.live="selected_machines" value="{{ $machine->name }}" style="transform: scale(1.5);">
                                        </label> -->

                                        <!-- Share Trigger Button -->
                                        <button type="button" @click="showShare = !showShare" style="position: absolute; bottom: 10px; right: 10px; z-index: 20; background: white; border: none; border-radius: 50%; width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 5px rgba(0,0,0,0.2); cursor: pointer;" title="Share">
                                            <i class="fas fa-share-alt" style="color: #333;"></i>
                                        </button>
                                        
                                        @if($machine->status == 'rented')
                                            <div style="position: absolute; top: 10px; left: 10px; z-index: 10;">
                                                <span class="badge bg-warning text-dark">Rented</span>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="pbminfotech-box-content">
                                        <div class="pbminfotech-titlebox">
                                            <div class="pbmit-port-cat">
                                                <a href="#" rel="tag">{{ $machine->category->name ?? 'Uncategorized' }}</a>
                                            </div>
                                            <h3 class="pbmit-portfolio-title">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <a href="#" data-bs-toggle="tooltip" data-bs-placement="top" title="{{ $machine->description }}">{{ $machine->name }}</a>
                                                </div>
                                            </h3>
                                            @if($machine->pricing)
                                                <div class="text-primary fw-bold mt-1">${{ number_format($machine->pricing, 2) }}</div>
                                            @endif
                                            <div class="form-check mt-2">
                                                <input class="form-check-input" type="checkbox" wire:model.live="selected_machines" value="{{ $machine->name }}" id="check-{{ $machine->id }}">
                                                <label class="form-check-label" for="check-{{ $machine->id }}" style="font-size: 14px; font-weight: normal;">
                                                    Select for Quote
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Share Popup Modal (Bottom Right of Card) -->
                                    <div x-show="showShare" @click.away="showShare = false" style="display: none; position: absolute; bottom: 60px; right: 10px; z-index: 999; background: white; padding: 15px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.2); width: 250px;" x-transition>
                                        <div class="d-flex justify-content-between align-items-center mb-2">
                                            <h6 class="m-0" style="font-size: 14px; font-weight: 600;">Share</h6>
                                            <button type="button" @click="showShare = false" style="background: none; border: none; font-size: 16px; cursor: pointer; color: #999;">&times;</button>
                                        </div>
                                        
                                        <div class="d-flex gap-2 justify-content-center mb-3">
                                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(route('machines')) }}" target="_blank" class="btn btn-sm btn-light rounded-circle" style="width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; color: #3b5998;"><i class="fab fa-facebook-f"></i></a>
                                            <a href="https://twitter.com/intent/tweet?text={{ urlencode('Check out ' . $machine->name) }}&url={{ urlencode(route('machines')) }}" target="_blank" class="btn btn-sm btn-light rounded-circle" style="width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; color: #1da1f2;"><i class="fab fa-twitter"></i></a>
                                            <a href="https://wa.me/?text={{ urlencode('Check out ' . $machine->name . ': ' . $machine->description) }}" target="_blank" class="btn btn-sm btn-light rounded-circle" style="width: 32px; height: 32px; display: flex; align-items: center; justify-content: center; color: #25d366;"><i class="fab fa-whatsapp"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </article>
                            @empty
                                <div class="col-12 text-center py-5">
                                    <h4>No machines found matching your criteria.</h4>
                                </div>
                            @endforelse
                        </div>
                        <div class="mt-4">
                            {{ $machines->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Machines Grid End -->

        <!-- Quote Form -->
        <section class="contact-us-section section-md bg-light">
            <div class="container">
                <div class="row align-items-center mb-4">
                    <div class="col-md-12">
                        <div class="pbmit-heading-subheading text-center">
                            <h4 class="pbmit-subtitle">Request a Quote</h4>
                            <h2 class="pbmit-title">Get a Custom Quote for Selected Machines</h2>
                        </div>
                    </div>
                </div>
                
                <div class="row justify-content-center">
                    <div class="col-md-10">
                        @if (session()->has('message'))
                            <div class="alert alert-success">
                                {{ session('message') }}
                            </div>
                        @endif

                        <form wire:submit.prevent="submitQuote" class="contact-form left-box">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="p-3 border rounded bg-white">
                                        <strong>Selected Machines:</strong>
                                        @if(empty($selected_machines))
                                            <span class="text-muted fst-italic">No machines selected yet. Please select from the list above.</span>
                                        @else
                                            <ul class="list-inline d-inline mb-0">
                                                @foreach($selected_machines as $selected)
                                                    <li class="list-inline-item badge bg-primary text-white">{{ $selected }}</li>
                                                @endforeach
                                            </ul>
                                        @endif
                                        @error('selected_machines') <span class="text-danger d-block mt-1">{{ $message }}</span> @enderror
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <input type="text" class="form-control" placeholder="Full Name *" wire:model="name" required>
                                    @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-md-6">
                                    <input type="email" class="form-control" placeholder="Your Email *" wire:model="email" required>
                                    @error('email') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-md-12">
                                    <input type="text" class="form-control" placeholder="Your Phone *" wire:model="phone" required>
                                    @error('phone') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-md-12">
                                    <textarea wire:model="message" cols="40" rows="5" class="form-control" placeholder="Project Details / Additional Comments *" required></textarea>
                                    @error('message') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-md-12 mt-3 text-center">
                                    <button type="submit" class="pbmit-btn">
                                        <span class="pbmit-button-content-wrapper">
                                            <span class="pbmit-button-icon">
                                                <i class="pbmit-induyst-icon pbmit-induyst-icon-next"></i>
                                            </span>
                                            <span class="pbmit-button-text">Request Quote</span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!-- Quote Form End -->

    </div>
</div>
