<div>
    @push('schema')
    <script type="application/ld+json">
        {!! json_encode($schema) !!}
    </script>
    @endpush
    <!-- Title Bar -->
	<div class="pbmit-title-bar-wrapper">
		<div class="container">
			<div class="pbmit-title-bar-content">
				<div class="pbmit-title-bar-content-inner">
					<div class="pbmit-tbar">
						<div class="pbmit-tbar-inner container">
							<h1 class="pbmit-tbar-title"> {{ $blog->title }}</h1>
						</div>
					</div>
					<div class="pbmit-breadcrumb">
						<div class="pbmit-breadcrumb-inner">
							<span>
								<a title="" href="{{ route('home') }}" class="home"><span>Home</span></a>
							</span>
							<span class="sep"></span>
							<span>
								<a title="" href="{{ route('blogs') }}"><span>Blogs</span></a>
							</span>
							<span class="sep"></span>
							<span><span class="post-root post post-post current-item"> {{ Str::limit($blog->title, 20) }}</span></span>
						</div>
					</div>
				</div>
			</div> 
		</div> 
	</div>
	<!-- Title Bar End-->

	<!-- Page Content -->
	<div class="page-content"> 

		<!-- Blog Single Details -->
		<section class="site-content blog-details">
			<div class="container">
				<div class="row">
					<div class="col-md-9 blog-left-col">
						<div class="row">
							<div class="col-md-12">
								<article>
									<div class="post blog-classic"> 
										<div class="pbmit-img-wrapper">
											<div class="pbmit-featured-img-wrapper">
												<div class="pbmit-featured-wrapper">
													<img src="{{ $blog->image }}" class="img-fluid" alt="{{ $blog->title }}">
												</div>
											</div>  
											<span class="pbmit-meta pbmit-meta-date">
												<span class="pbmit-date">{{ $blog->created_at->format('d') }}</span>
												<span class="pbmit-month">{{ $blog->created_at->format('M') }}</span>
											</span>
										</div>
										<div class="pbmit-blog-classic-inner">
											<div class="pbmit-blog-meta pbmit-blog-meta-top">
												<span class="pbmit-meta pbmit-meta-author">by <a class="pbmit-author-link" href="#">{{ $blog->user->name ?? 'Admin' }}</a>
												</span>	
												<span class="pbmit-meta pbmit-meta-cat">
													<a href="#" rel="bookmark">{{ $blog->category->name ?? 'Uncategorized' }}</a>
												</span>
												<span class="pbmit-meta pbmit-meta-comments">
													{{ $blog->comments->count() }} Comments
												</span>
											</div>
											<h3 class="pbmit-post-title">
												<a href="#">{{ $blog->title }}</a>
											</h3>
											<div class="pbmit-entry-content">
                                                {!! $blog->content !!}
											</div>
											<div class="pbmit-blog-meta-bottom">
												<div class="pbmit-blog-meta-bottom-left">
													<ul class="tagcloud">
                                                        <!-- Assuming meta_keywords are comma separated -->
                                                        @if($blog->meta_keywords)
                                                            @foreach(explode(',', $blog->meta_keywords) as $keyword)
														        <li><a href="#">{{ trim($keyword) }}</a></li>
                                                            @endforeach
                                                        @endif
													</ul>
												</div>
												<div class="pbmit-blog-meta-bottom-right">
													<div class="pbmit-social-share">
														<ul>
															<li class="pbmit-social-li pbmit-social-li-facebook">
																<a class="pbmit-popup" href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}" target="_blank" title="Share on Facebook">
																	<i class="pbmit-base-icon-facebook-squared"></i>
																</a>
															</li>
															<li class="pbmit-social-li pbmit-social-li-twitter">
																<a class="pbmit-popup" href="https://twitter.com/intent/tweet?text={{ urlencode($blog->title) }}&url={{ url()->current() }}" target="_blank" title="Share on X (Twitter)">
																	<i class="pbmit-base-icon-twitter-2"></i>
																</a>
															</li>
															<li class="pbmit-social-li pbmit-social-li-linkedin">
																<a class="pbmit-popup" href="https://www.linkedin.com/shareArticle?mini=true&url={{ url()->current() }}&title={{ urlencode($blog->title) }}" target="_blank" title="Share on LinkedIn">
																	<i class="pbmit-base-icon-linkedin-squared"></i>
																</a>
															</li>
														</ul>
													</div>
												</div>
											</div>
										</div>   
									</div> 
									<nav class="navigation post-navigation" aria-label="Posts">
										<div class="nav-links">
                                            @if($previousBlog)
											<div class="nav-previous">
												<a href="{{ route('blog.detail', $previousBlog->slug) }}" rel="prev">
													<span class="pbmit-post-nav-icon">
														<i class="pbmit-base-icon-arrow-left"></i>
														<span class="pbmit-post-nav-head">Previous Post</span>
													</span>
													<span class="pbmit-post-nav-wrapper">
														<span class="pbmit-post-nav nav-title">{{ Str::limit($previousBlog->title, 40) }}</span> 
													</span>
												</a>
											</div>
                                            @endif
                                            @if($nextBlog)
											<div class="nav-next">
												<a href="{{ route('blog.detail', $nextBlog->slug) }}" rel="next">
													<span class="pbmit-post-nav-icon">
														<span class="pbmit-post-nav-head">Next Post</span>
														<i class="pbmit-base-icon-arrow-right"></i>
													</span>
													<span class="pbmit-post-nav-wrapper">
														<span class="pbmit-post-nav nav-title">{{ Str::limit($nextBlog->title, 40) }}</span> 
													</span>
												</a>
											</div>
                                            @endif
										</div>
									</nav>
									<div class="pbmit-author-box">
										<div class="pbmit-author-image">
										   <img alt="" src="{{ $blog->user->profile_photo_url ?? asset('assets/images/avatar.png') }}" class="img-fluid">			
										</div>
										<div class="pbmit-author-content">
										   <span class="pbmit-author-name">
										  	 <a href="#" title="Posted by {{ $blog->user->name }}" rel="author">{{ $blog->user->name ?? 'Admin' }}</a>
										   </span>
										   <p class="pbmit-text pbmit-author-bio">
                                               {{-- Bio not available in User model by default, using placeholder or empty --}}
                                               Author at Dumes.
                                           </p>
										</div>
									</div>
								</article>
								<div class="comments-area">
									<h2 class="comments-title">{{ $blog->comments->count() }} Replies to “{{ $blog->title }}”</h2>
                                    
									<ul class="comment-list">
                                        @foreach($blog->comments as $comment)
										<li class="comment depth-1">
											<div class="pbmit-comment">
												<div class="pbmit-comment-avatar">
													<img src="https://ui-avatars.com/api/?name={{ urlencode($comment->name) }}&background=random" class="img-fluid" alt="">
												</div>
												<div class="pbmit-comment-content">
													<div class="pbmit-comment-meta">
														<span class="pbmit-comment-author">by
															<span class="pbmit-comment-author-inner">
																<a href="#">{{ $comment->name }}</a>
															</span>
														</span>
														<span class="pbmit-comment-date">
															<a href="#">{{ $comment->created_at->diffForHumans() }}</a>
														</span>
													</div>
													<p>{{ $comment->content }}</p>
													<div class="reply">
														<a href="#comment-form">Reply</a>
													</div>
												</div>
											</div>
										</li>
                                        @endforeach
									</ul>

									<div class="comment-respond pbmit-bg-color-light">
										<h3 class="comment-reply-title">Leave a Reply </h3>
                                        @if(session()->has('success_comment'))
                                            <div class="alert alert-success">
                                                {{ session('success_comment') }}
                                            </div>
                                        @endif
										<div class="comment-form">
											<p class="comment-notes">Your email address will not be published. Required fields are marked *</p>
											<form class="contact-form" wire:submit.prevent="saveComment">
												<div class="row">
													<div class="col-sm-12">
														<label for="comment">Comment <span class="required">*</span></label>
														<textarea required="" class="form-control" id="comment" wire:model="comment" cols="45" rows="8"></textarea>
                                                        @error('comment') <span class="text-danger">{{ $message }}</span> @enderror
													</div>
													<div class="col-sm-12"> 
														<label for="author">Name <span class="required">*</span></label>
														<input id="author" type="text" class="form-control" wire:model="name" required>
                                                        @error('name') <span class="text-danger">{{ $message }}</span> @enderror
													</div>
													<div class="col-sm-12"> 
														<label for="email">Email <span class="required">*</span></label>
														<input id="email" class="form-control" wire:model="email" type="email" required>
                                                        @error('email') <span class="text-danger">{{ $message }}</span> @enderror
													</div>
                                                   
													<div class="col-sm-12"> 
														<button type="submit" class="submit-btn pbmit-btn">
															<span class="form-btn-loader d-none">
                                                                <!-- Loading SVG -->
															</span>
															<span>Post Comment</span>
														</button>
                                                        <div wire:loading wire:target="saveComment">Posting...</div>
													</div>
												</div>
											</form>
										</div>
									</div>
								</div>
							</div> 
						</div>
					</div>
					<div class="col-md-3 blog-right-col">
						<aside class="sidebar">
							<aside class="widget widget-search">
								<form class="search-form">
									<input placeholder="Search …" value="" name="s" type="search">
									<button type="button" class="search-submit"></button>
								</form>
							</aside>
							
							<aside class="widget widget-categories">
								<h2 class="widget-title">Categories</h2>
								<ul>
                                    @foreach($categories as $category)
									<li>
										<span class="pbmit-cat-li">
											<a href="#">{{ $category->name }}</a>
											<span class="pbmit-brackets">( {{ $category->blogs_count }} )</span>
										</span>
									</li>
                                    @endforeach
								</ul>
							</aside>
							<aside class="widget widget-recent-post">
								<h2 class="widget-title">Recent Post</h2>
								<ul class="recent-post-list">
                                    @foreach($recentBlogs as $rBlog)
									<li class="recent-post-list-li"> 
										<a class="recent-post-thum" href="{{ route('blog.detail', $rBlog->slug) }}">
											<img src="{{ $rBlog->image }}" class="img-fluid" alt="{{ $rBlog->title }}">
										</a>
										<div class="pbmit-rpw-content">
											<span class="pbmit-rpw-title">
												<a href="{{ route('blog.detail', $rBlog->slug) }}">{{ $rBlog->title }}</a>
											</span>
											<span class="pbmit-rpw-date">
												<a href="{{ route('blog.detail', $rBlog->slug) }}">{{ $rBlog->created_at->format('d M Y') }}</a>
											</span>
										</div> 
									</li>
                                    @endforeach
								</ul>
							</aside> 
							
							<aside class="widget widget-tag-cloud">
								<h3 class="widget-title">Tag Cloud</h3>
								<ul class="tagcloud">
                                    @if(isset($tags) && $tags->count() > 0)
                                        @foreach($tags as $tag)
									        <li><a href="{{ route('blogs', ['tag' => $tag]) }}">{{ $tag }}</a></li>
                                        @endforeach
                                    @else
                                        <li>No unique tags</li>
                                    @endif
								</ul>
							</aside> 
						</aside>
					</div>
				</div>
			</div>
		</section>
		<!-- Blog Single Details End -->
		
	</div>
</div>
