<div>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">

    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-12">
                @if (session('message'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session('message') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif

                @if (session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Healthcare Job Applications</h5>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-flush table-striped table-hover table-bordered" id="datatable-applications">
                            <thead class="thead-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Surname</th>
                                    <th>First Name</th>
                                    <th>Previous Surnames</th>
                                    <th>Previous Surnames Evidence</th>
                                    <th>Telephone Number</th>
                                    <th>Email</th>
                                    <th>Position Applied For</th>
                                    <th>Location</th>
                                    <th>Work Preference</th>
                                    <th>Hours Requested</th>
                                    <th>Understands Role</th>
                                    <th>Availability</th>
                                    <th>Address</th>
                                    <th>Postcode</th>
                                    <th>Mobile Number</th>
                                    <th>NI Number</th>
                                    <th>Gender</th>
                                    <th>Is Driver</th>
                                    <th>Own Transport</th>
                                    <th>Licence Duration</th>
                                    <th>Endorsements</th>
                                    <th>UK National</th>
                                    <th>Visa Details</th>
                                    <th>Is Related</th>
                                    <th>Reasonable Adjustments</th>
                                    <th>Education</th>
                                    <th>Training</th>
                                    <th>Memberships</th>
                                    <th>Employment</th>
                                    <th>Gaps Explanation</th>
                                    <th>Referee 1</th>
                                    <th>Referee 2</th>
                                    <th>Unspent Convictions</th>
                                    <th>Unspent Cautions</th>
                                    <th>Print Full Name</th>
                                    <th>Identity Proof</th>
                                    <th>Copy Passport Proof</th>
                                    <th>Drivers Licence Proof</th>
                                    <th>Bank Account Proof</th>
                                    <th>Qualifications Proof</th>
                                    <th>Current Address Proof</th>
                                    <th>NINO Proof Attachment</th>
                                    <th>Passport Sized Photo</th>
                                    <th>Current DBS Proof</th>
                                    <th>Statement of Entry Proof</th>
                                    <th>Mandatory Training Proof</th>
                                    <th>Signature</th>
                                    <th>Date</th>
                                    <th>Created At</th>
                                    <th>Updated At</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($applications as $application)
                                    <tr>
                                        <td>{{ $application->id }}</td>
                                        <td>{{ $application->surname }}</td>
                                        <td>{{ $application->firstname }}</td>
                                        <td>{{ $application->previous_surnames }}</td>
                                        <td>{{ $application->previous_surnames_evidence }}</td>
                                        <td>{{ $application->telephone_number }}</td>
                                        <td>{{ $application->your_email }}</td>
                                        <td>{{ $application->position_applied_for }}</td>
                                        <td>{{ $application->location }}</td>
                                        <td>{{ $application->work_preference }}</td>
                                        <td>{{ $application->hours_requested }}</td>
                                        <td>{{ $application->understands_role }}</td>
                                        <td>{{ json_encode($application->availability) }}</td>
                                        <td>{{ $application->address }}</td>
                                        <td>{{ $application->postcode }}</td>
                                        <td>{{ $application->mobile_number }}</td>
                                        <td>{{ $application->ni_number }}</td>
                                        <td>{{ $application->gender }}</td>
                                        <td>{{ $application->is_driver }}</td>
                                        <td>{{ $application->own_transport }}</td>
                                        <td>{{ $application->licence_duration }}</td>
                                        <td>{{ $application->endorsements }}</td>
                                        <td>{{ $application->uk_national }}</td>
                                        <td>{{ $application->visa_details }}</td>
                                        <td>{{ $application->is_related }}</td>
                                        <td>{{ $application->reasonable_adjustments }}</td>
                                        <td>{{ json_encode($application->education) }}</td>
                                        <td>{{ json_encode($application->training) }}</td>
                                        <td>{{ json_encode($application->memberships) }}</td>
                                        <td>{{ json_encode($application->employment) }}</td>
                                        <td>{{ $application->gaps_explanation }}</td>
                                        <td>{{ json_encode($application->referee1) }}</td>
                                        <td>{{ json_encode($application->referee2) }}</td>
                                        <td>{{ $application->unspent_convictions }}</td>
                                        <td>{{ $application->unspent_cautions }}</td>
                                        <td>{{ $application->print_full_name }}</td>
                                        <td>@if($application->identity_proof)<a href="{{ $application->identity_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->copy_passport_proof)<a href="{{ $application->copy_passport_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->drivers_licence_proof)<a href="{{ $application->drivers_licence_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->bank_account_proof)<a href="{{ $application->bank_account_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->qualifications_proof)<a href="{{ $application->qualifications_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->current_address_proof)<a href="{{ $application->current_address_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->nino_proof_attachment)<a href="{{ $application->nino_proof_attachment }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->passport_sized_photo)<a href="{{ $application->passport_sized_photo }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->current_dbs_proof)<a href="{{ $application->current_dbs_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->statement_of_entry_proof)<a href="{{ $application->statement_of_entry_proof }}" target="_blank">View</a>@endif</td>
                                        <td>@if($application->mandatory_training_proof)<a href="{{ $application->mandatory_training_proof }}" target="_blank">View</a>@endif</td>
                                        <td>{{ $application->signature }}</td>
                                        <td>{{ \Carbon\Carbon::parse($application->date)->format('M d, Y') }}</td>
                                        <td>{{ \Carbon\Carbon::parse($application->created_at)->format('M d, Y H:i:s') }}</td>
                                        <td>{{ \Carbon\Carbon::parse($application->updated_at)->format('M d, Y H:i:s') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="d-flex justify-content-center mt-4">
                        {{ $applications->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
        <script>
            document.addEventListener('livewire:initialized', function () {
                const dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                    searchable: true,
                    fixedHeight: true,
                    perPage: {{ $perPage }},
                    perPageSelect: [5, 10, 25, 50],
                    labels: {
                        placeholder: "Search...",
                        perPage: "{select} entries per page",
                        noRows: "No entries found",
                        info: "Showing {start} to {end} of {rows} entries"
                    }
                });

                Livewire.on('tableUpdated', () => {
                    dataTableSearch.destroy();
                    dataTableSearch = new simpleDatatables.DataTable("#datatable-applications", {
                        searchable: true,
                        fixedHeight: true,
                        perPage: {{ $perPage }},
                        perPageSelect: [5, 10, 25, 50],
                        labels: {
                            placeholder: "Search...",
                            perPage: "{select} entries per page",
                            noRows: "No entries found",
                            info: "Showing {start} to {end} of {rows} entries"
                        }
                    });
                });
            });
        </script>
    @endpush
</div>