<div class="container-fluid py-4">
    <div class="row mb-5">
        <div class="col-12 text-end">
            <a href="{{ route('admin.equipment') }}" class="btn btn-outline-secondary">
                <i class="bi bi-arrow-left me-1"></i> Back to All Equipment
            </a>
        </div>
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-gradient-primary-custom">
                    <h5 class="mb-0 text-white">{{ $equipment_id ? 'Edit Equipment' : 'Add New Equipment' }}</h5>
                </div>
                <div class="card-body">
                    @if(session()->has('message'))
                        <div class="alert alert-success text-white alert-dismissible fade show" role="alert">
                            {{ session('message') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    @if(session()->has('error'))
                        <div class="alert alert-danger text-white alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                    <form wire:submit.prevent="{{ $equipment_id ? 'updateEquipment' : 'addEquipment' }}">
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">Equipment Name</label>
                                <div class="input-group input-group-outline">
                                    <input type="text" class="form-control" wire:model="name" wire:keyup="generateSlug">
                                </div>
                                @error('name') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">Slug</label>
                                <div class="input-group input-group-outline">
                                    <input type="text" class="form-control" wire:model="slug">
                                </div>
                                @error('slug') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">Category</label>
                                <div class="input-group input-group-outline">
                                    <select class="form-control" wire:model="category_id">
                                        <option value="">Select Category</option>
                                        @foreach ($categories as $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('category_id') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">Status</label>
                                <div class="input-group input-group-outline">
                                    <select class="form-control" wire:model="status">
                                        <option value="available">Available</option>
                                        <option value="rented">Rented</option>
                                        <option value="maintenance">Maintenance</option>
                                    </select>
                                </div>
                                @error('status') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">Pricing (Optional)</label>
                                <div class="input-group input-group-outline">
                                    <input type="number" step="0.01" class="form-control" wire:model="pricing">
                                </div>
                                @error('pricing') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label fw-bold">Image</label>
                                <div class="input-group input-group-outline">
                                    <input type="file" class="form-control" wire:model="{{ $equipment_id ? 'newimage' : 'image' }}">
                                </div>
                                <small class="text-muted d-block mt-1 text-xs">Max upload size: 5MB. Supported formats: JPG, PNG.</small>
                                
                            
                                @if($newimage)
                                    <img src="{{ $newimage->temporaryUrl() }}" width="120" class="mt-2 rounded border">
                                @elseif($image)
                                    @if(is_object($image) && method_exists($image, 'temporaryUrl'))
                                        <img src="{{ $image->temporaryUrl() }}" width="120" class="mt-2 rounded border">
                                    @elseif(is_string($image))
                                        @if(str_contains($image, 'http'))
                                            <img src="{{ $image }}" width="120" class="mt-2 rounded border">
                                        @else
                                            <img src="{{ asset('assets/images/equipment') }}/{{ $image }}" width="120" class="mt-2 rounded border">
                                        @endif
                                    @endif
                                @endif
                                @error('image') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                                @error('newimage') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-12 mb-4">
                                <label class="form-label fw-bold">Specifications (Short Description)</label>
                                <div class="input-group input-group-outline">
                                    <textarea class="form-control" rows="3" wire:model="specifications"></textarea>
                                </div>
                                @error('specifications') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-12 mb-4">
                                <label class="form-label fw-bold">Description (Detail)</label>
                                <div class="input-group input-group-outline">
                                    <textarea class="form-control" rows="5" wire:model="description"></textarea>
                                </div>
                                @error('description') <span class="text-danger text-xs">{{ $message }}</span> @enderror
                            </div>

                            <div class="col-12 text-end">
                                <button type="submit" class="btn bg-gradient-dark" wire:loading.attr="disabled">
                                    <span wire:loading.remove>{{ $equipment_id ? 'Update Equipment' : 'Add Equipment' }}</span>
                                    <span wire:loading>Processing...</span>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@script
<script>
    document.addEventListener('livewire:file:upload-error', (event) => {
         // This catches the standard Livewire upload error
         console.error('Upload Error Event:', event);
         // Try to extract useful info
         let msg = 'File Upload Failed.';
         if(event.detail && event.detail.error) {
             msg += ' ' + event.detail.error;
         }
         alert(msg);
    });
</script>
@endscript
