<div>
<div class="container-fluid py-4">
    <div class="row mb-5">
        <div class="col-12 text-end">
            <a href="{{ route('admin.equipment.add') }}" class="btn btn-primary-custom">
                <i class="bi bi-plus-lg me-1"></i> Add Equipment
            </a>
        </div>
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-gradient-primary-custom text-white">
                    <h5 class="mb-0 text-white">All Equipment</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead>
                                <tr class="bg-light">
                                    <th class="text-secondary text-xs font-weight-bold opacity-7 ps-3">Id</th>
                                    <th class="text-secondary text-xs font-weight-bold opacity-7">Image</th>
                                    <th class="text-secondary text-xs font-weight-bold opacity-7 ps-2">Name</th>
                                    <th class="text-secondary text-xs font-weight-bold opacity-7 ps-2">Category</th>
                                    <th class="text-secondary text-xs font-weight-bold opacity-7 ps-2">Price</th>
                                    <th class="text-secondary text-xs font-weight-bold opacity-7 ps-2">Status</th>
                                    <th class="text-center text-secondary text-xs font-weight-bold opacity-7">Date</th>
                                    <th class="text-center text-secondary text-xs font-weight-bold opacity-7">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($equipments as $equipment)
                                    <tr>
                                        <td class="text-sm ps-3">{{ $equipment->id }}</td>
                                        <td>
                                            <div class="d-flex px-2 py-1">
                                                @if(str_contains($equipment->image, 'http'))
                                                    <img src="{{ $equipment->image }}" class="rounded avatar-lg me-3" alt="{{ $equipment->name }}" style="max-height: 50px;">
                                                @else
                                                    <img src="{{ asset('assets/images/equipment') }}/{{ $equipment->image }}" class="rounded avatar-lg me-3" alt="{{ $equipment->name }}" style="max-height: 50px;">
                                                @endif
                                            </div>
                                        </td>
                                        <td><h6 class="mb-0 text-sm">{{ $equipment->name }}</h6></td>
                                        <td><p class="text-xs font-weight-bold mb-0">{{ $equipment->category->name ?? 'N/A' }}</p></td>
                                        <td><p class="text-xs font-weight-bold mb-0">{{ $equipment->pricing ? '$'.$equipment->pricing : 'N/A' }}</p></td>
                                        <td>
                                            @if($equipment->status == 'available')
                                                <span class="badge bg-gradient-success">Available</span>
                                            @elseif($equipment->status == 'rented')
                                                <span class="badge bg-gradient-warning">Rented</span>
                                            @else
                                                <span class="badge bg-gradient-danger">Maintenance</span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            <span class="text-secondary text-xs font-weight-bold">{{ $equipment->created_at->format('d M Y') }}</span>
                                        </td>
                                        <td class="text-center">
                                            <a href="{{ route('admin.equipment.edit', ['slug' => $equipment->slug]) }}" class="text-primary fs-5 me-2" data-bs-toggle="tooltip" data-bs-title="Edit">
                                                <i class="bi bi-pencil-square"></i>
                                            </a>
                                            <a href="#" onclick="confirm('Are you sure you want to delete this equipment?') || event.stopImmediatePropagation()" wire:click.prevent="deleteEquipment({{ $equipment->id }})" class="text-danger fs-5" data-bs-toggle="tooltip" data-bs-title="Delete">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer d-flex justify-content-end">
                    {{ $equipments->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
