<?php

namespace App\Livewire;

use Livewire\Component;

class ServiceDetailComponent extends Component
{
    public $slug;
    public $service;
    public $allServices;

    public function mount($slug)
    {
        $this->slug = $slug;
        $this->allServices = $this->getServices();
        $this->service = collect($this->allServices)->firstWhere('slug', $slug);

        if (!$this->service) {
            abort(404);
        }
    }

    private function getServices()
    {
        return [
            [
                'title' => 'Heavy-Duty Equipment Leasing',
                'slug' => 'heavy-duty-equipment-leasing',
                'image' => '/assets/images/homepage-1/service/heavy.jpg',
                'icon' => 'fas fa-tractor',
                'description' => 'We lease durable, high-performance machines for road construction, building projects, earthworks, industrial operations, and more. Our fleet is regularly serviced to guarantee safety, efficiency, and maximum productivity on site.',
                'long_description' => 'Our heavy-duty equipment leasing service provides you with top-tier machinery essential for any large-scale construction or industrial project. We understand that the quality of your equipment directly impacts your project\'s timeline and safety. That\'s why we offer a comprehensive fleet of well-maintained excavators, payloaders, graders, rollers, cranes, and lowbeds. Whether you need equipment for a short-term job or a long-term contract, we offer flexible leasing plans tailored to your specific needs.',
                'features' => [
                    'Wide range of heavy machinery available',
                    'Flexible leasing terms (short & long term)',
                    'Regularly serviced and maintained fleet',
                    'Experienced operators available upon request'
                ]
            ],
            [
                'title' => 'Civil Works & Infrastructure',
                'slug' => 'civil-works-infrastructure',
                'image' => '/assets/images/homepage-1/service/civil-works.jpg',
                'icon' => 'fas fa-road',
                'description' => 'We execute a wide range of civil engineering projects, including: Road construction and rehabilitation, Drainage systems development, Solar street light installation, Structural works and site preparation. Our team ensures every project meets industry standards with precision and timely delivery.',
                'long_description' => 'Our Civil Works & Infrastructure service is dedicated to building the foundations of modern communities. From constructing durable roads that connect cities to designing efficient drainage systems that prevent flooding, we handle every aspect of civil engineering with expertise. We pride ourselves on delivering projects that stand the test of time, adhering to strict safety and quality standards.',
                'features' => [
                    'Road construction and rehabilitation',
                    'Drainage system design and installation',
                    'Structural engineering works',
                    'Adherence to international safety standards'
                ]
            ],
            [
                'title' => 'Logistics & Procurement',
                'slug' => 'logistics-procurement',
                'image' => '/assets/images/homepage-1/service/logistics_procurement.jpg',
                'icon' => 'fas fa-truck-fast',
                'description' => 'We support organizations with reliable logistics coordination, equipment transportation, material sourcing, and procurement services. Our goal is to streamline your operations and ensure access to the right resources at the right time.',
                'long_description' => 'Efficient logistics and procurement are the backbone of any successful project. We offer end-to-end solutions that cover everything from sourcing high-quality materials to transporting heavy equipment to remote sites. Our logistics team ensures that your supply chain remains uninterrupted, allowing you to focus on the core aspects of your project.',
                'features' => [
                    'Material sourcing and procurement',
                    'Heavy equipment transportation',
                    'Supply chain management',
                    'Timely delivery to project sites'
                ]
            ],
            [
                'title' => 'Site Preparation & Earthworks',
                'slug' => 'site-preparation-earthworks',
                'image' => '/assets/images/homepage-1/service/site_preparation.jpg',
                'icon' => 'fas fa-trowel-bricks',
                'description' => 'Professional excavation, grading, land clearing, and foundation preparation for construction projects.',
                'long_description' => 'Before any construction can begin, the site must be properly prepared. Our site preparation and earthworks services ensure that your land is ready for development. We handle excavation, grading, land clearing, and soil stabilization with precision equipment, creating a solid foundation for your project\'s success.',
                'features' => [
                    'Land clearing and grading',
                    'Excavation and trenching',
                    'Soil stabilization',
                    'Foundation preparation'
                ]
            ],
            [
                'title' => 'Road Construction and Drains',
                'slug' => 'road-construction-drains',
                'image' => '/assets/images/homepage-1/service/construction_drainage.jpg',
                'icon' => 'fas fa-hard-hat',
                'description' => 'Expert road construction and drainage system installation to ensure durable infrastructure and water management.',
                'long_description' => 'We specialize in constructing high-quality roads and effective drainage systems. Our road construction services cover everything from earthworks to paving, ensuring a smooth and durable surface. Our drainage solutions are designed to manage water flow effectively, preventing erosion and flooding even in heavy rainfall areas.',
                'features' => [
                    'Asphalt and concrete road paving',
                    'Culvert and drain installation',
                    'Erosion control systems',
                    'Road maintenance and repair'
                ]
            ],
            [
                'title' => 'Solar Street Light Installations',
                'slug' => 'solar-street-light-installations',
                'image' => '/assets/images/homepage-1/service/solar-street-lights.jpg',
                'icon' => 'fas fa-lightbulb',
                'description' => 'Sustainable solar street lighting solutions for communities, ensuring safety and efficiency with renewable power.',
                'long_description' => 'Illuminate your community sustainably with our solar street light installation services. We provide eco-friendly lighting solutions that reduce energy costs and reliance on the grid. Our installations are designed for durability and efficiency, providing reliable lighting for streets, pathways, and public, enhancing safety and security.',
                'features' => [
                    'Renewable energy lighting solutions',
                    'Cost-effective and low maintenance',
                    'Enhanced community safety',
                    'Professional installation and support'
                ]
            ]
        ];
    }

    public function render()
    {
        return view('livewire.service-detail-component')->layout('components.layouts.base');
    }
}
