<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\JobApplication;
class AdminJobApplicationComponent extends Component
{
    use WithPagination;

    public $perPage = 10;

    public function render()
    {
        $applications = JobApplication::with('job')->orderBy('created_at', 'desc')->paginate($this->perPage);
        return view('livewire.admin.admin-job-application-component', compact('applications'))
            ->layout('layouts.adminbase');
    }
}
