<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Equipment;

class AdminEquipmentComponent extends Component
{
    use WithPagination;

    public function deleteEquipment($id)
    {
        $equipment = Equipment::find($id);
        if($equipment) {
            $equipment->delete();
            session()->flash('message', 'Equipment has been deleted successfully!');
        }
    }

    public function render()
    {
        $equipments = Equipment::orderBy('created_at', 'DESC')->paginate(12);
        return view('livewire.admin.admin-equipment-component', ['equipments' => $equipments])->layout('layouts.adminbase');
    }
}
