<?php

namespace App\Livewire\Admin;

use App\Models\Category;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

class AdminCategoryComponent extends Component
{
    use WithPagination;

    public $name, $categoryId, $isEdit = false;
public $showModal = false;
public $sortField = 'name';
public $sortDirection = 'asc';
public $perPage = 10;

protected $rules = [
    'name' => 'required|string|max:255',
];

public function openModal($id = null)
{
    if ($id) {
        $category = Category::findOrFail($id);
        $this->categoryId = $category->id;
        $this->name = $category->name;
        $this->isEdit = true;
    } else {
        $this->resetForm();
        $this->isEdit = false;
    }
    $this->showModal = true;
    $this->dispatch('show-modal'); // Updated to use Livewire's dispatch
}

public function resetForm()
{
    $this->name = '';
    $this->categoryId = null;
    $this->isEdit = false;
}

public function save()
{
    $this->validate();

    if ($this->isEdit) {
        $category = Category::findOrFail($this->categoryId);
        $category->update([
            'name' => $this->name,
            'slug' => Str::slug($this->name),
           

        ]);
    } else {
        Category::create([
            'name' => $this->name,
            'slug' => Str::slug($this->name),
            

        ]);
    }

    $this->showModal = false;
    $this->resetForm();
    $this->dispatch('hide-modal'); // Dispatch to hide modal after save
}

public function delete($id)
{
    Category::findOrFail($id)->delete();
    session()->flash('message', 'Category deleted successfully!');
}

public function sortBy($field)
{
    if ($this->sortField === $field) {
        $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
    } else {
        $this->sortField = $field;
        $this->sortDirection = 'asc';
    }
}

public function previousPage()
{
    $this->setPage(max($this->page - 1, 1));
}

public function nextPage()
{
    $this->setPage(min($this->page + 1, $this->lastPage));
}

public function gotoPage($page)
{
    $this->setPage(max(1, min($page, $this->lastPage)));
}

public function render()
{
    $categories = Category::orderBy($this->sortField, $this->sortDirection)
        ->paginate($this->perPage);
    return view('livewire.admin.admin-category-component', [
        'categories' => $categories,
    ])->layout('layouts.adminbase');
}

}