<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Blog;
use App\Models\Category;
use Livewire\WithFileUploads;
use Illuminate\Support\Str;
use CloudinaryLabs\CloudinaryLaravel\Facades\Cloudinary;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use App\Models\SeoField;

class AdminBlogComponent extends Component
{
    public function delete($id)
    {
        $blog = Blog::findOrFail($id);

        // Delete featured image
        if ($blog->image) {
            $this->deleteCloudinaryImage($blog->image);
        }

        // Delete images from content
        if (preg_match_all('/<img src="(https:\/\/res.cloudinary.com\/[^"]+)"/', $blog->content, $matches)) {
            foreach ($matches[1] as $imageUrl) {
                $this->deleteCloudinaryImage($imageUrl);
            }
        }

        $blog->delete();
        session()->flash('message', 'Blog deleted successfully!');
    }

    private function deleteCloudinaryImage($imageUrl)
    {
        $path = parse_url($imageUrl, PHP_URL_PATH);
        $parts = explode('/', $path);
        $publicIdToDelete = null;
        $uploadIndex = array_search('upload', $parts);

        if ($uploadIndex !== false && count($parts) > $uploadIndex + 2) {
            $publicIdWithFolderAndExtension = implode('/', array_slice($parts, $uploadIndex + 2));
            $folderPath = dirname($publicIdWithFolderAndExtension);
            $filename = pathinfo($publicIdWithFolderAndExtension, PATHINFO_FILENAME);
            
            if ($folderPath === '.') {
                $publicIdToDelete = $filename;
            } else {
                $publicIdToDelete = $folderPath . '/' . $filename;
            }
        }

        if ($publicIdToDelete) {
            try {
                Cloudinary::destroy($publicIdToDelete);
                Log::info('Image deleted from Cloudinary: ' . $publicIdToDelete);
            } catch (\Exception $e) {
                Log::error('Failed to delete image from Cloudinary: ' . $e->getMessage());
                session()->flash('error', 'Failed to delete image from Cloudinary: ' . $e->getMessage());
            }
        }
    }
    
    public function render()
    {
        $blogs = Blog::with('category', 'user')->get();
        return view('livewire.admin.admin-blog-component', compact('blogs'))->layout('layouts.adminbase');
    }
}
